/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.NormalizedPoint;
import lt.monarch.chart.PlainMapper;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.ChartPoint;
import lt.monarch.chart.chart2D.ChartPointProvider;
import lt.monarch.chart.chart2D.DotSeries;
import lt.monarch.chart.chart2D.NormalizedPoint2D;

public class ConnectedSeries
extends DotSeries {
    protected Color lineColor = Color.red;
    protected Color fillColor = null;
    protected Stroke lineStroke;

    public ConnectedSeries(ChartPointProvider chartPointProvider, PlainMapper plainMapper, AxisMapper axisMapper, AxisMapper axisMapper2) {
        super(chartPointProvider, plainMapper, axisMapper, axisMapper2);
    }

    public ConnectedSeries(ChartPointProvider chartPointProvider, Axis2D axis2D, Axis2D axis2D2) {
        super(chartPointProvider, axis2D, axis2D2);
    }

    public void draw(Graphics graphics) {
        Point point;
        Object object;
        Polygon polygon = new Polygon();
        double d = 0.0;
        double d2 = 0.0;
        int n = this.provider.pointCount();
        int n2 = 0;
        while (n2 < n) {
            object = this.provider.point(n2).getCenter(graphics, this);
            point = this.chart().projector().project((NormalizedPoint)object);
            polygon.addPoint(point.x, point.y);
            d2 = ((NormalizedPoint2D)object).x;
            if (n2 == 0) {
                d = d2;
            }
            ++n2;
        }
        if (n != 0 && this.fillColor != null) {
            object = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            point = this.chart().projector().project(this.mapper.map(d2, 0.0));
            ((Polygon)object).addPoint(point.x, point.y);
            Point point2 = this.chart().projector().project(this.mapper.map(d, 0.0));
            ((Polygon)object).addPoint(point2.x, point2.y);
            graphics.setColor(this.fillColor);
            graphics.fillPolygon((Polygon)object);
        }
        object = null;
        if (this.lineStroke != null) {
            object = ((Graphics2D)graphics).getStroke();
            ((Graphics2D)graphics).setStroke(this.lineStroke);
        }
        graphics.setColor(this.lineColor);
        graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        if (object != null) {
            ((Graphics2D)graphics).setStroke((Stroke)object);
        }
        this.drawPoints(graphics);
    }

    public void pointAdded(ChartPointProvider chartPointProvider, ChartPoint chartPoint) {
        this.chart().invalidate();
    }

    public void setColor(Color color) {
        this.lineColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStroke(Stroke stroke) {
        this.lineStroke = stroke;
    }
}

