/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import lt.monarch.chart.AbstractChart;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.Projector;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.Projector2D;

public class Chart2D
extends AbstractChart {
    protected final int border = 10;
    protected Projector2D projector = new Projector2D();
    protected ChartObject[] objects;
    protected Axis2DX axisB;
    protected Axis2DY axisL;
    protected Axis2DY axisR;

    public void enableAspectRatio11() {
        this.projector = new Projector2D();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.objects == null) {
            return;
        }
        int n = 0;
        while (n < this.objects.length) {
            this.objects[n].draw(graphics);
            ++n;
        }
    }

    protected void prepareChart(Graphics graphics) {
        if (this.axisB != null) {
            this.axisB.prepare();
        }
        if (this.axisL != null) {
            this.axisL.prepare();
        }
        if (this.axisR != null) {
            this.axisR.prepare();
        }
        int n = this.axisR != null ? this.axisR.width(graphics) : 0;
        int n2 = this.axisL != null ? this.axisL.width(graphics) : 0;
        int n3 = this.axisB != null ? this.axisB.height(graphics) : 0;
        Rectangle rectangle = new Rectangle(this.area.x + 10 + n2, this.area.y + 10, this.area.width - n2 - n - 20, this.area.height - n3 - 20);
        this.projector.setProjectionArea(rectangle);
    }

    public Projector projector() {
        return this.projector;
    }

    public void reset() {
        if (this.objects != null) {
            int n = 0;
            while (n < this.objects.length) {
                this.objects[n].setChart(null);
                ++n;
            }
        }
        this.objects = null;
        this.requestPreparation();
    }

    public void setLAxis(Axis2DY axis2DY) {
        this.axisL = axis2DY;
        this.axisL.alignRight = false;
        this.requestPreparation();
    }

    public void setObjects(ChartObject[] chartObjectArray) {
        this.reset();
        this.objects = chartObjectArray;
        int n = 0;
        while (n < this.objects.length) {
            this.objects[n].setChart(this);
            ++n;
        }
    }

    public void setRAxis(Axis2DY axis2DY) {
        this.axisR = axis2DY;
        this.axisR.alignRight = true;
        this.requestPreparation();
    }

    public void setXAxis(Axis2DX axis2DX) {
        this.axisB = axis2DX;
        this.requestPreparation();
    }

    public String tipAt(Point point) {
        String string = null;
        int n = this.objects.length - 1;
        while (n >= 0 && string == null) {
            string = this.objects[n].tipAt(point);
            --n;
        }
        return string;
    }
}

