/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.Projector;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.NormalizedPoint2D;

public class Axis2DY
extends Axis2D {
    boolean alignRight;

    public Axis2DY(AxisMapper axisMapper) {
        super(axisMapper);
    }

    public void draw(Graphics graphics) {
        Projector projector = this.chart().projector();
        Point point = projector.project(new NormalizedPoint2D(0.0, 0.0));
        Point point2 = projector.project(new NormalizedPoint2D(1.0, 1.0));
        graphics.setColor(Color.black);
        if (this.alignRight) {
            graphics.drawLine(point2.x, point.y, point2.x, point2.y);
        } else {
            graphics.drawLine(point.x, point.y, point.x, point2.y);
        }
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(" ");
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.mapper.labelCount()) {
            n2 += fontMetrics.getHeight();
            ++n3;
        }
        int n4 = n2 / Math.abs(point.y - point2.y) + 1;
        int n5 = this.label != null ? n4 : 0;
        int n6 = 0;
        while (n6 < this.mapper.labelCount() - n5) {
            String string = this.mapper.label(n6);
            Point point3 = projector.project(new NormalizedPoint2D(this.alignRight ? 1 : 0, this.mapper.mapLabel(n6)));
            if (this.alignRight) {
                graphics.drawString(string, point3.x + n * 2, point3.y + fontMetrics.getHeight() / 3);
                graphics.drawLine(point3.x, point3.y, point3.x + n, point3.y);
            } else {
                graphics.drawString(string, point3.x - n * 2 - fontMetrics.stringWidth(string), point3.y + fontMetrics.getHeight() / 3);
                graphics.drawLine(point3.x, point3.y, point3.x - n, point3.y);
            }
            n6 += n4;
        }
        if (this.label != null) {
            int n7 = this.alignRight ? point2.x + n : point.x - n - fontMetrics.stringWidth(this.label);
            graphics.drawString(this.label, n7, point2.y + fontMetrics.getHeight() / 2);
        }
    }

    public int width(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(" ");
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.mapper.labelCount()) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.mapper.label(n3)));
            ++n3;
        }
        if (this.label != null) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.label));
        }
        return n2 + n;
    }
}

