/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart;

public class NormalizedMatrix {
    public final int resolutionX;
    public final int resolutionY;
    public double[][] z;

    public void normalize(double d, double d2) {
        double d3 = d2 - d;
        int n = 0;
        while (n < this.resolutionY) {
            int n2 = 0;
            while (n2 < this.resolutionX) {
                this.z[n2][n] = (this.z[n2][n] - d) / d3;
                ++n2;
            }
            ++n;
        }
    }

    public void normalize() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = 0;
        while (n < this.resolutionY) {
            int n2 = 0;
            while (n2 < this.resolutionX) {
                if (this.z[n2][n] > d2 && this.z[n2][n] != Double.POSITIVE_INFINITY) {
                    d2 = this.z[n2][n];
                }
                if (this.z[n2][n] < d && this.z[n2][n] != Double.NEGATIVE_INFINITY) {
                    d = this.z[n2][n];
                }
                ++n2;
            }
            ++n;
        }
        this.normalize(d, d2);
    }

    public void logBase(double d) {
        int n = 0;
        while (n < this.resolutionY) {
            int n2 = 0;
            while (n2 < this.resolutionX) {
                this.z[n2][n] = Math.log(this.z[n2][n] + d);
                ++n2;
            }
            ++n;
        }
    }

    public void soften3x3() {
        double[][] dArray = new double[this.resolutionX + 2][this.resolutionY + 2];
        int n = 0;
        while (n < this.resolutionX) {
            System.arraycopy(this.z[n], 0, dArray[n + 1], 1, this.resolutionY);
            dArray[n][0] = dArray[n][1];
            dArray[n][this.resolutionY + 1] = dArray[n][this.resolutionY];
            ++n;
        }
        System.arraycopy(dArray[1], 0, dArray[0], 0, this.resolutionY + 2);
        System.arraycopy(dArray[this.resolutionX], 0, dArray[this.resolutionX + 1], 0, this.resolutionY + 2);
        int n2 = 0;
        while (n2 < this.resolutionY) {
            n = 0;
            while (n < this.resolutionX) {
                this.z[n][n2] = (dArray[n][n2] * 1.0 + dArray[n + 1][n2] * 2.0 + dArray[n + 2][n2] * 1.0 + dArray[n][n2 + 1] * 2.0 + dArray[n + 1][n2 + 1] * 3.0 + dArray[n + 2][n2 + 1] * 2.0 + dArray[n][n2 + 2] * 1.0 + dArray[n + 1][n2 + 2] * 2.0 + dArray[n + 2][n2 + 2] * 1.0) / 15.0;
                ++n;
            }
            ++n2;
        }
    }

    public void soften5x5() {
        double[][] dArray = new double[this.resolutionX + 4][this.resolutionY + 4];
        int n = 0;
        while (n < this.resolutionX) {
            System.arraycopy(this.z[n], 0, dArray[n + 2], 2, this.resolutionY);
            double d = dArray[n][2];
            dArray[n][1] = d;
            dArray[n][0] = d;
            double d2 = dArray[n][this.resolutionY + 1];
            dArray[n][this.resolutionY + 2] = d2;
            dArray[n][this.resolutionY + 3] = d2;
            ++n;
        }
        System.arraycopy(dArray[2], 0, dArray[0], 0, this.resolutionY + 4);
        System.arraycopy(dArray[2], 0, dArray[1], 0, this.resolutionY + 4);
        System.arraycopy(dArray[this.resolutionX + 2], 0, dArray[this.resolutionX + 2], 0, this.resolutionY + 4);
        System.arraycopy(dArray[this.resolutionX + 2], 0, dArray[this.resolutionX + 3], 0, this.resolutionY + 4);
        int n2 = 0;
        while (n2 < this.resolutionY) {
            n = 0;
            while (n < this.resolutionX) {
                this.z[n][n2] = (dArray[n][n2] * 0.0 + dArray[n + 1][n2] * 1.0 + dArray[n + 2][n2] * 2.0 + dArray[n + 3][n2] * 1.0 + dArray[n + 4][n2] * 0.0 + dArray[n][n2 + 1] * 1.0 + dArray[n + 1][n2 + 1] * 2.0 + dArray[n + 2][n2 + 1] * 3.0 + dArray[n + 3][n2 + 1] * 2.0 + dArray[n + 4][n2 + 1] * 1.0 + dArray[n][n2 + 2] * 2.0 + dArray[n + 1][n2 + 2] * 3.0 + dArray[n + 2][n2 + 2] * 4.0 + dArray[n + 3][n2 + 2] * 3.0 + dArray[n + 4][n2 + 2] * 2.0 + dArray[n][n2 + 3] * 1.0 + dArray[n + 1][n2 + 3] * 2.0 + dArray[n + 2][n2 + 3] * 3.0 + dArray[n + 3][n2 + 3] * 2.0 + dArray[n + 4][n2 + 3] * 1.0 + dArray[n][n2 + 4] * 0.0 + dArray[n + 1][n2 + 4] * 1.0 + dArray[n + 2][n2 + 4] * 2.0 + dArray[n + 3][n2 + 4] * 1.0 + dArray[n + 4][n2 + 4] * 0.0) / 40.0;
                ++n;
            }
            ++n2;
        }
    }

    public NormalizedMatrix(int n, int n2) {
        this.resolutionX = n;
        this.resolutionY = n2;
        this.z = new double[this.resolutionX][this.resolutionY];
    }
}

