/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import lt.monarch.chart.AbstractChartObject;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.NormalizedPoint;
import lt.monarch.chart.PlainMapper;
import lt.monarch.chart.Projector;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.PlainMapper2D;

public class Grid
extends AbstractChartObject {
    protected final PlainMapper mapper;
    protected final AxisMapper xMapper;
    protected final AxisMapper yMapper;
    protected Color gridColor;
    protected Color fillColor;

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void draw(Graphics graphics) {
        Point point;
        Point point2;
        Projector projector = this.chart().projector();
        NormalizedPoint normalizedPoint = this.mapper.map(0.0, 0.0);
        if (this.fillColor != null) {
            graphics.setColor(this.fillColor);
            point2 = projector.project(this.mapper.map(0.0, 0.0, normalizedPoint));
            point = projector.project(this.mapper.map(0.0, 1.0, normalizedPoint));
            Point point3 = projector.project(this.mapper.map(1.0, 1.0, normalizedPoint));
            Point point4 = projector.project(this.mapper.map(1.0, 0.0, normalizedPoint));
            Polygon polygon = new Polygon();
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point.x, point.y);
            polygon.addPoint(point3.x, point3.y);
            polygon.addPoint(point4.x, point4.y);
            graphics.fillPolygon(polygon);
            graphics.setColor(this.gridColor);
            graphics.drawPolygon(polygon);
        }
        point2 = new Point();
        point = new Point();
        graphics.setColor(this.gridColor);
        if (this.yMapper != null) {
            int n = 0;
            while (n < this.yMapper.labelCount()) {
                double d = this.yMapper.mapLabel(n);
                projector.project(this.mapper.map(0.0, d, normalizedPoint), point2);
                projector.project(this.mapper.map(1.0, d, normalizedPoint), point);
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                ++n;
            }
        }
        if (this.xMapper != null) {
            int n = 0;
            while (n < this.xMapper.labelCount()) {
                double d = this.xMapper.mapLabel(n);
                projector.project(this.mapper.map(d, 0.0, normalizedPoint), point2);
                projector.project(this.mapper.map(d, 1.0, normalizedPoint), point);
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                ++n;
            }
        }
    }

    public Grid(PlainMapper plainMapper, AxisMapper axisMapper, AxisMapper axisMapper2) {
        this.mapper = plainMapper;
        this.xMapper = axisMapper;
        this.yMapper = axisMapper2;
        this.gridColor = Color.gray;
        this.fillColor = new Color(240, 240, 240);
    }

    public Grid(Axis2D axis2D, Axis2D axis2D2) {
        this(new PlainMapper2D(), axis2D == null ? null : axis2D.mapper, axis2D2 == null ? null : axis2D2.mapper);
    }
}

