/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import lt.monarch.chart.Chart;
import lt.monarch.chart.ChartContainer;
import lt.monarch.chart.Projector;

public abstract class AbstractChart
implements Chart {
    protected ChartContainer container = null;
    protected Rectangle area = null;
    protected boolean needPreparation = true;
    protected Color background = Color.white;

    public void setBackground(Color color) {
        this.background = color;
    }

    public void refresh() {
        Graphics graphics = this.container.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
            graphics.finalize();
        }
    }

    public void invalidate() {
        this.requestPreparation();
        this.container.repaint();
    }

    public void setContainer(ChartContainer chartContainer, Rectangle rectangle) {
        this.container = chartContainer;
        this.area = rectangle;
        this.requestPreparation();
    }

    protected void requestPreparation() {
        this.needPreparation = true;
    }

    protected void prepareChart(Graphics graphics) {
    }

    protected void preparePaint(Graphics graphics) {
        if (this.needPreparation) {
            this.needPreparation = false;
            this.prepareChart(graphics);
        }
    }

    public void paint(Graphics graphics) {
        this.preparePaint(graphics);
        if (this.background != null) {
            graphics.setColor(this.background);
            Rectangle rectangle = this.projector().getProjectionArea();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public ChartContainer container() {
        return this.container;
    }

    public String tipAt(Point point) {
        return null;
    }

    public abstract Projector projector();
}

