/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class TextLabel
extends Canvas {
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    protected String[] text;
    protected int alignment;

    public TextLabel() {
        this(2);
    }

    public TextLabel(int n) {
        this.text = new String[0];
        this.alignment = n;
    }

    public TextLabel(String string) {
        this(string, 2);
    }

    public TextLabel(String string, int n) {
        this.alignment = n;
        this.setText(string);
    }

    public TextLabel(String[] stringArray) {
        this(stringArray, 2);
    }

    public TextLabel(String[] stringArray, int n) {
        this.alignment = n;
        this.text = stringArray;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(" ");
        int n2 = 0;
        while (n2 < this.text.length) {
            switch (this.alignment) {
                case 3: {
                    graphics.drawString(this.text[n2], rectangle.width - fontMetrics.stringWidth(this.text[n2]) - n, n2 * fontMetrics.getHeight() + fontMetrics.getAscent());
                    break;
                }
                case 2: {
                    graphics.drawString(this.text[n2], n, n2 * fontMetrics.getHeight() + fontMetrics.getAscent());
                    break;
                }
                case 1: {
                    graphics.drawString(this.text[n2], (rectangle.width - fontMetrics.stringWidth(this.text[n2])) / 2, n2 * fontMetrics.getHeight() + fontMetrics.getAscent());
                    break;
                }
            }
            ++n2;
        }
    }

    public Dimension preferredSize() {
        int n;
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.text.length) {
            n = fontMetrics.stringWidth(this.text[n3]);
            if (n2 < n) {
                n2 = n;
            }
            ++n3;
        }
        n = fontMetrics.stringWidth(" ");
        return new Dimension(n2 + n * 2, this.text.length * fontMetrics.getHeight());
    }

    public void setText(String string) {
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        this.text = new String[n];
        int n3 = 0;
        while (n3 < n) {
            this.text[n3] = new String();
            ++n3;
        }
        n = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            switch (string.charAt(n4)) {
                case '\n': {
                    ++n;
                    break;
                }
                default: {
                    int n5 = n;
                    this.text[n5] = String.valueOf(this.text[n5]) + string.charAt(n4);
                }
                case '\r': 
            }
            ++n4;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

