/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.awt;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Vector;

public class MathImageSource
implements ImageProducer {
    protected double[] imageData;
    protected int[] pixels;
    protected int[] palette;
    protected int width;
    protected int height;
    protected int levelCount = 256;
    Vector theConsumers = new Vector();
    ColorModel colorModel = ColorModel.getRGBdefault();

    public MathImageSource(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.imageData = new double[n * n2];
        this.pixels = new int[n * n2 * 10];
        this.createPalette();
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        block4: {
            if (this.theConsumers.contains(imageConsumer)) {
                return;
            }
            this.theConsumers.addElement(imageConsumer);
            try {
                this.initConsumer(imageConsumer);
                this.sendPixelsTo(imageConsumer);
                if (this.isConsumer(imageConsumer)) {
                    imageConsumer.imageComplete(3);
                    return;
                }
            }
            catch (Exception exception) {
                if (!this.isConsumer(imageConsumer)) break block4;
                imageConsumer.imageComplete(1);
            }
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.imageData.length) {
            this.imageData[n] = 0.0;
            this.pixels[n] = 0;
            ++n;
        }
        this.update();
    }

    private void createPalette() {
        this.palette = new int[this.levelCount];
        float[] fArray = new float[]{0.46875f, 0.9765625f, 0.0390625f};
        float[] fArray2 = new float[]{0.1757813f, 0.9375f, 0.9960938f};
        float[] fArray3 = new float[3];
        int n = 0;
        while (n < this.levelCount) {
            float f = (float)n / (float)(this.levelCount - 1);
            fArray3[0] = (1.0f + fArray2[0] - fArray[0]) * f + fArray[0];
            fArray3[1] = (fArray[1] - fArray2[1]) * f + fArray2[1];
            fArray3[2] = (fArray2[2] - fArray[2]) * f + fArray[2];
            if (fArray3[0] > 1.0f) {
                fArray3[0] = fArray3[0] - 1.0f;
            }
            this.palette[n] = Color.HSBtoRGB(fArray3[0], fArray3[1], fArray3[2]);
            ++n;
        }
    }

    private void initConsumer(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setDimensions(this.width, this.height);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setColorModel(this.colorModel);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setHints(30);
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.theConsumers.contains(imageConsumer);
    }

    public synchronized void refresh() {
        this.refreshPixels();
    }

    protected void refreshPixels() {
        int n = 0;
        double d = Double.MIN_NORMAL;
        double d2 = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.imageData.length) {
            if (d < this.imageData[n2]) {
                d = this.imageData[n2];
            }
            if (d2 > this.imageData[n2]) {
                d2 = this.imageData[n2];
            }
            ++n2;
        }
        double d3 = d - d2;
        double d4 = Math.log(d3 + 1.0);
        double d5 = this.levelCount - 1;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                double d6 = this.imageData[n] - d2;
                d6 = Math.log(d6 + 1.0) / d4;
                this.pixels[n++] = this.palette[(int)(d6 * d5)];
                ++n4;
            }
            ++n3;
        }
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.theConsumers.removeElement(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void sendPixelsTo(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setPixels(0, 0, this.width, this.height, this.colorModel, this.pixels, 0, this.width);
        }
    }

    public void setLevelCount(int n) {
        this.levelCount = n;
        this.createPalette();
        this.refresh();
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public synchronized void update() {
        Enumeration enumeration = this.theConsumers.elements();
        while (enumeration.hasMoreElements()) {
            ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
            this.sendPixelsTo(imageConsumer);
            imageConsumer.imageComplete(3);
        }
    }
}

