/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.awt;

import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import lt.monarch.awt.CardSelectorListener;

public class CardSelector
extends Canvas {
    private Container container;
    private String[] pages;
    private boolean[] pageEnabled;
    private int selectedPage;
    private Vector listeners = new Vector();
    private final int tabExtraWidth = 15;
    private final int tabSlope = 5;
    private final int tabSpacing = -4;

    public CardSelector(Container container, String[] stringArray) {
        this.container = container;
        this.pages = stringArray;
        this.pageEnabled = new boolean[this.pages.length];
        int n = 0;
        while (n < this.pageEnabled.length) {
            this.pageEnabled[n] = true;
            ++n;
        }
        this.container.setBackground(Color.lightGray);
    }

    public void addPageChangeListener(CardSelectorListener cardSelectorListener) {
        this.listeners.addElement(cardSelectorListener);
    }

    public final void disablePage(String string) {
        this.enablePage(string, false);
    }

    void drawTab(Graphics graphics, int n, String string, boolean bl, boolean bl2) {
        Rectangle rectangle = this.bounds();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = bl ? 2 : 4;
        Polygon polygon = new Polygon();
        polygon.addPoint(n, rectangle.height);
        polygon.addPoint(n + 5, n3);
        polygon.addPoint(n + n2 + 15 + 5, n3);
        polygon.addPoint(n + n2 + 15 + 10, rectangle.height);
        graphics.setColor(Color.lightGray);
        graphics.fillPolygon(polygon);
        graphics.setColor(Color.white);
        graphics.drawLine(n + 1, rectangle.height, n + 5 + 1, n3);
        graphics.drawLine(n + 5 + 1, n3 + 1, n + n2 + 15 + 5 + 1, n3 + 1);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n + n2 + 15 + 5 - 1, n3, n + n2 + 15 + 10 - 1, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawPolygon(polygon);
        if (bl2) {
            graphics.setColor(Color.black);
            graphics.drawString(string, n + 7 + 5, n3 + fontMetrics.getHeight());
            return;
        }
        graphics.setColor(Color.white);
        graphics.drawString(string, n + 7 + 5, n3 + fontMetrics.getHeight());
        graphics.setColor(Color.gray);
        graphics.drawString(string, n + 7 + 5 - 1, n3 + fontMetrics.getHeight() - 1);
    }

    public final void enablePage(String string) {
        this.enablePage(string, true);
    }

    public void enablePage(String string, boolean bl) {
        int n = 0;
        while (n < this.pages.length) {
            if (this.pages[n].equals(string)) {
                this.pageEnabled[n] = bl;
            }
            ++n;
        }
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.requestFocus();
        this.bounds();
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.pages.length) {
            int n5 = fontMetrics.stringWidth(this.pages[n4]);
            if (n < (n3 += n5 + 15 + 10 + -4)) {
                this.turnToPage(n4);
                return true;
            }
            ++n4;
        }
        return false;
    }

    public void paint(Graphics graphics) {
        int n;
        Rectangle rectangle = this.bounds();
        Rectangle rectangle2 = graphics.getClipRect();
        graphics.clearRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = n = 0;
        int n3 = 0;
        while (n3 < this.pages.length) {
            if (n3 != this.selectedPage) {
                this.drawTab(graphics, n, this.pages[n3], false, this.pageEnabled[n3]);
            } else {
                n2 = n;
            }
            n += -4 + this.tabWidth(fontMetrics, n3);
            ++n3;
        }
        this.drawTab(graphics, n2, this.pages[this.selectedPage], true, true);
        graphics.setColor(Color.white);
        graphics.drawLine(0, rectangle.height - 1, n2, rectangle.height - 1);
        graphics.setColor(Color.black);
        graphics.drawLine(0, rectangle.height - 2, n2, rectangle.height - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(n2 += this.tabWidth(fontMetrics, this.selectedPage), rectangle.height - 1, rectangle.width, rectangle.height - 1);
        graphics.setColor(Color.black);
        graphics.drawLine(n2, rectangle.height - 2, rectangle.width, rectangle.height - 2);
    }

    public Dimension preferredSize() {
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        int n2 = 0;
        while (n2 < this.pages.length) {
            n += fontMetrics.stringWidth(this.pages[n2]) + 15 + 10 + -4;
            ++n2;
        }
        return new Dimension(n, fontMetrics.getHeight() * 3 / 2);
    }

    public int tabWidth(FontMetrics fontMetrics, int n) {
        return fontMetrics.stringWidth(this.pages[n]) + 15 + 10;
    }

    public void turnToPage(int n) {
        if (this.pageEnabled[n] && n != this.selectedPage) {
            this.selectedPage = n;
            ((CardLayout)this.container.getLayout()).show(this.container, this.pages[n]);
            this.repaint();
            int n2 = 0;
            while (n2 < this.listeners.size()) {
                ((CardSelectorListener)this.listeners.elementAt(n2)).pageChanged(n);
                ++n2;
            }
        }
    }
}

