/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import lt.ktu.gmj.Method;
import lt.ktu.gmj.Task;
import lt.ktu.gmj.TaskWithAnalyzers;
import lt.ktu.gmj.analysis.ResultAnalyzer;
import lt.ktu.gmj.propertySheet.Header;
import lt.ktu.gmj.propertySheet.PropertySheet;
import lt.ktu.gmj.ui.Logo;
import lt.ktu.gmj.ui.Minimizer;
import lt.ktu.gmj.ui.MinimizerDirector;
import lt.ktu.gmj.ui.ResultSet;
import lt.ktu.gmj.ui.ResultSheet;
import lt.monarch.debug.ErrorLog;
import lt.monarch.debug.MultiLogEngine;
import lt.monarch.debug.StdErrLogEngine;
import lt.monarch.debug.SwingListLogEngine;
import lt.monarch.swing.applet.AppletFrame;

public class GMJ
extends JApplet
implements MinimizerDirector,
Runnable {
    static final String[] logoText = new String[]{"Method algorithms by Jonas Mockus", "Design&Implementation by Modestas Grybauskas", "e-mail: Modestas_G@equinoxlt.com"};
    protected static String taskNames;
    protected static String methodNames;
    protected static String analysisNames;
    protected Logo logo;
    protected JTabbedPane pages;
    protected Method method;
    protected JComboBox methodChoice;
    protected PropertySheet methodProperties;
    protected Hashtable methods;
    protected Task task;
    protected JComboBox taskChoice;
    protected PropertySheet taskProperties;
    protected JButton run;
    protected JButton pause;
    protected JButton stop;
    protected JButton analysis;
    protected Minimizer minimizer;
    protected ResultSet results;
    protected ResultSheet resultProperties;
    JPopupMenu jpopupmenu;

    static {
        MultiLogEngine multiLogEngine = new MultiLogEngine();
        multiLogEngine.addLogEngine(new SwingListLogEngine());
        multiLogEngine.addLogEngine(new StdErrLogEngine());
        ErrorLog.setDefaultLog(new ErrorLog(multiLogEngine));
    }

    public GMJ() {
        GlobalTools.setApplet(this);
        this.method = null;
        this.methods = new Hashtable();
        this.task = null;
    }

    protected static String completeClassName(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string.equals(GMJ.shortClassName(string2))) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    protected void enableControls() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run.setEnabled(this.minimizer == null || this.minimizer != null && this.minimizer.isSuspended());
            this.pause.setEnabled(this.minimizer != null && !this.minimizer.isSuspended());
            this.stop.setEnabled(this.minimizer != null);
            this.analysis.setEnabled(this.results != null);
            this.stop.setText("Stop");
            this.pages.setEnabledAt(0, this.minimizer == null);
            this.pages.setEnabledAt(1, this.minimizer == null);
            this.pages.setEnabledAt(2, this.method != null && this.task != null);
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public String getAppletInfo() {
        return this.logo.getInfo();
    }

    public void init() {
        GlobalTools.setApplet(this);
        try {
            try {
                taskNames = this.getParameter("TASKS");
            }
            catch (NullPointerException nullPointerException) {}
            try {
                methodNames = this.getParameter("METHODS");
            }
            catch (NullPointerException nullPointerException) {}
            try {
                analysisNames = this.getParameter("ANALYSIS");
            }
            catch (NullPointerException nullPointerException) {}
            this.pages = new JTabbedPane();
            this.pages.setBackground(Color.white);
            this.getContentPane().setBackground(new Color(230, 230, 230));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.pages);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(2));
            jPanel.add(new JLabel("Select method and properties:"));
            this.methodChoice = new JComboBox();
            jPanel.add(this.methodChoice);
            this.methodProperties = new PropertySheet();
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout(4, 4));
            jPanel2.add("North", jPanel);
            jPanel2.add("Center", this.methodProperties);
            this.pages.addTab("Method", jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(2));
            jPanel3.add(new JLabel("Select task and properties:"));
            this.taskChoice = new JComboBox();
            jPanel3.add(this.taskChoice);
            this.taskProperties = new PropertySheet();
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout(4, 4));
            jPanel4.add("North", jPanel3);
            jPanel4.add("Center", this.taskProperties);
            this.pages.add("Task", jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new GridLayout(1, 4));
            this.run = new JButton("Run");
            this.pause = new JButton("Pause");
            this.stop = new JButton("Stop");
            this.analysis = new JButton("Analysis");
            jPanel5.add(this.run);
            jPanel5.add(this.pause);
            jPanel5.add(this.stop);
            jPanel5.add(this.analysis);
            this.run.setForeground(Color.green);
            this.stop.setForeground(Color.red);
            this.resultProperties = new ResultSheet();
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BorderLayout(4, 4));
            jPanel6.add("South", jPanel5);
            jPanel6.add("Center", this.resultProperties);
            this.pages.addTab("Operation", jPanel6);
            GMJ.loadClassChoice(this.methodChoice, GMJ.parseClassList(methodNames));
            GMJ.loadClassChoice(this.taskChoice, GMJ.parseClassList(taskNames));
            this.methodChoice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GMJ.this.stop();
                    GMJ.this.reloadMethod();
                }
            });
            this.taskChoice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GMJ.this.stop();
                    GMJ.this.reloadTask();
                }
            });
            this.run.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GMJ.this.minimizer != null) {
                        GMJ.this.minimizer.resumeMinimizer();
                    } else {
                        if (GMJ.this.results == null) {
                            GMJ.this.results = new ResultSet(GMJ.this.method, GMJ.this.task);
                            GMJ.this.results.addObserver(GMJ.this.resultProperties);
                        }
                        GMJ.this.minimizer = new Minimizer(GMJ.this, GMJ.this.results);
                        GMJ.this.minimizer.startMinimizer();
                    }
                }
            });
            this.pause.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GMJ.this.minimizer != null) {
                        GMJ.this.minimizer.suspendMinimizer();
                    }
                    GMJ.this.run.setEnabled(true);
                }
            });
            this.stop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GMJ.this.minimizer != null) {
                        GMJ.this.run.setEnabled(false);
                    }
                    GMJ.this.pause.setEnabled(false);
                    GMJ.this.stop.setEnabled(false);
                    GMJ.this.stop.setText("Wait...");
                    GMJ.this.stop();
                }
            });
            this.analysis.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GMJ.this.showAnalysisMenu();
                }
            });
            this.reloadMethod();
            this.reloadTask();
        }
        catch (Throwable throwable) {
            this.getContentPane().removeAll();
            ErrorLog.defaultLog().log("Initialization error", throwable);
        }
    }

    protected static void loadClassChoice(JComboBox jComboBox, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = GMJ.shortClassName(stringArray[n]);
            jComboBox.addItem(string);
            ++n;
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        System.out.println("Global Minimizer II For Java. Modestas Grybauskas 1999");
        if (stringArray.length == 0) {
            System.out.println("Syntax: java lt.ktu.gmj.ui.GMJ <task names> <method names> <analysis names>");
        }
        if (stringArray.length > 0) {
            taskNames = stringArray[0];
        }
        if (stringArray.length > 1) {
            methodNames = stringArray[1];
        }
        if (stringArray.length > 2) {
            analysisNames = stringArray[2];
        }
        new AppletFrame(new GMJ(), "GMJ", new Dimension(800, 500));
    }

    public void minimizationComplete() {
        this.minimizer = null;
        this.enableControls();
    }

    public void minimizerStateChanged() {
        this.enableControls();
    }

    protected static String[] parseClassList(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            ++n;
            if ((n2 = string.indexOf(124, n2)) == -1) {
                n2 = string.length();
            }
            ++n2;
        }
        int n3 = 0;
        String[] stringArray = new String[n];
        int n4 = 0;
        while (n4 < string.length()) {
            int n5 = string.indexOf(124, n4);
            if (n5 == -1) {
                n5 = string.length();
            }
            String string2 = string.substring(n4, n5);
            stringArray[n3++] = string2;
            n4 = n5;
            ++n4;
        }
        return stringArray;
    }

    protected void reloadMethod() {
        String string = GMJ.parseClassList(methodNames)[this.methodChoice.getSelectedIndex()];
        this.method = (Method)this.methods.get(string);
        this.methodProperties.removeAll();
        this.method = null;
        if (this.method == null) {
            try {
                this.method = (Method)Class.forName(string).newInstance();
                this.methods.put(string, this.method);
            }
            catch (Throwable throwable) {
                this.enableControls();
                this.methodProperties.complete();
                ErrorLog.defaultLog().log("Method could not be initialized", throwable);
                return;
            }
        }
        this.methodProperties.add(new Header("Property", "Value"));
        this.method.customize(this.methodProperties);
        this.methodProperties.complete();
        this.enableControls();
    }

    protected void reloadTask() {
        String string = GMJ.parseClassList(taskNames)[this.taskChoice.getSelectedIndex()];
        this.taskProperties.removeAll();
        this.task = null;
        try {
            this.task = (Task)Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            this.enableControls();
            this.taskProperties.complete();
            ErrorLog.defaultLog().log("Task could not be initialized", throwable);
            return;
        }
        this.taskProperties.add(new Header("Property", "Value"));
        this.task.customize(this.taskProperties);
        this.task.domain().customize(this.taskProperties);
        this.taskProperties.complete();
        this.enableControls();
    }

    protected void removeLogo() {
        if (this.logo != null) {
            this.remove(this.logo);
            this.logo = null;
            this.validate();
        }
    }

    public void run() {
        this.enableControls();
    }

    protected static final String shortClassName(String string) {
        return string.indexOf(46) == -1 ? string : string.substring(string.lastIndexOf(46) + 1);
    }

    private void showAnalysisMenu() {
        this.jpopupmenu = new JPopupMenu("Analysis methods");
        String[] stringArray = GMJ.parseClassList(analysisNames);
        int n = 0;
        while (n < stringArray.length) {
            this.jpopupmenu.add(new AnalysisAction(stringArray[n]));
            ++n;
        }
        if (this.task instanceof TaskWithAnalyzers) {
            try {
                Class[] classArray = ((TaskWithAnalyzers)this.task).analyzers();
                if (classArray != null) {
                    int n2 = 0;
                    while (n2 < classArray.length) {
                        this.jpopupmenu.add(new AnalysisAction(classArray[n2].getName()));
                        ++n2;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        this.jpopupmenu.show(this.analysis, 0, this.analysis.getBounds().height);
    }

    public void stop() {
        if (this.minimizer != null) {
            this.minimizer.stopMinimizer();
            try {
                this.minimizer.join();
            }
            catch (InterruptedException interruptedException) {}
            this.minimizer = null;
        }
        if (this.results != null) {
            this.results.dispose();
            this.results = null;
        }
        this.enableControls();
    }

    protected final class AnalysisAction
    extends AbstractAction {
        String className;

        public AnalysisAction(String string) {
            this.className = string;
            this.putValue("Name", GMJ.shortClassName(string));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResultAnalyzer resultAnalyzer = null;
            try {
                resultAnalyzer = (ResultAnalyzer)Class.forName(this.className).newInstance();
                resultAnalyzer.prepare(GMJ.this.results);
            }
            catch (Throwable throwable) {
                if (resultAnalyzer != null) {
                    resultAnalyzer.dispose();
                }
                GMJ.this.enableControls();
                ErrorLog.defaultLog().log("Analysis could not be initialized", throwable);
            }
        }
    }
}

