/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.tasks;

import lt.ktu.gmj.AbstractTask;
import lt.ktu.gmj.Domain;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.TaskWithAnalyzers;
import lt.ktu.gmj.propertySheet.ChoiceProperty;
import lt.ktu.gmj.propertySheet.DoubleProperty;
import lt.ktu.gmj.propertySheet.FieldProvider;
import lt.ktu.gmj.propertySheet.PropertyManager;
import lt.ktu.gmj.tasks.SinDomain;

public class Sin
extends AbstractTask
implements TaskWithAnalyzers {
    private SinDomain domain = new SinDomain();
    public double multiplier = 1.0;
    public int function = 1;

    public Class[] analyzers() throws ClassNotFoundException {
        Class<?> clazz = Class.forName("lt.ktu.gmj.analysis.Spectrum");
        return new Class[]{clazz};
    }

    public void customize(PropertyManager propertyManager) {
        String[] stringArray = new String[]{"sin", "cos"};
        propertyManager.add(new DoubleProperty("Multiplier", new FieldProvider(this, "multiplier"), 0.1, 1000.0));
        propertyManager.add(new ChoiceProperty("Function", new FieldProvider(this, "function"), stringArray));
    }

    public Domain domain() {
        return this.domain;
    }

    public double f(Point point) {
        return this.function != 0 ? Math.cos(point.x[0] * point.x[0] + point.x[1] * point.x[1]) * this.multiplier : Math.sin(point.x[0] * point.x[0] + point.x[1] * point.x[1]) * this.multiplier;
    }
}

