/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.propertySheet;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JTextField;
import lt.ktu.gmj.propertySheet.InvalidPropertyException;
import lt.ktu.gmj.propertySheet.NotifierTextField;
import lt.ktu.gmj.propertySheet.PropertyEditor;
import lt.ktu.gmj.propertySheet.PropertyObserver;
import lt.ktu.gmj.propertySheet.PropertyStringer;

public class StringablePropertyEditor
implements PropertyEditor {
    private PropertyStringer stringer = null;
    private JTextField editor = new NotifierTextField(this);
    private Color normalBackground = this.editor.getBackground();
    private Color normalForeground = this.editor.getForeground();

    public void setStringer(PropertyStringer propertyStringer) {
        this.stringer = propertyStringer;
        this.stringer.addObserver(this);
        this.refreshed();
    }

    public void refreshed() {
        this.editor.setText(this.stringer.getAsString());
        this.editor.setBackground(this.normalBackground);
        this.editor.setForeground(this.normalForeground);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fieldChanged() {
        try {
            this.stringer.setAsString(this.editor.getText());
            this.editor.setBackground(this.normalBackground);
            this.editor.setForeground(this.normalForeground);
            return;
        }
        catch (InvalidPropertyException invalidPropertyException) {
            this.editor.setBackground(Color.red);
            this.editor.setForeground(Color.black);
        }
    }

    public JComponent component() {
        return this.editor;
    }

    public void refresh() {
    }

    public void addObserver(PropertyObserver propertyObserver) {
    }

    public StringablePropertyEditor(PropertyStringer propertyStringer) {
        this();
        this.setStringer(propertyStringer);
    }

    public StringablePropertyEditor() {
    }
}

