/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.propertySheet;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import lt.ktu.gmj.propertySheet.Property;
import lt.ktu.gmj.propertySheet.PropertyManager;

public class PropertySheet
extends JScrollPane
implements PropertyManager {
    protected Vector properties = new Vector();
    protected JPanel panel;
    GridBagLayout bag = new GridBagLayout();

    public void removeAll() {
        this.properties.removeAllElements();
        this.panel.removeAll();
    }

    public void add(Property property) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 2, 2);
        gridBagConstraints.gridy = this.properties.size();
        JComponent jComponent = property.label();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.bag.setConstraints(jComponent, gridBagConstraints);
        this.panel.add(jComponent);
        JComponent jComponent2 = property.editor().component();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.bag.setConstraints(jComponent2, gridBagConstraints);
        this.panel.add(jComponent2);
        this.properties.addElement(property);
    }

    public void complete() {
        this.panel.revalidate();
        this.revalidate();
        this.repaint();
    }

    public PropertySheet() {
        PropertySheet propertySheet = this;
        if (propertySheet == null) {
            throw null;
        }
        this.panel = propertySheet.new PropertyPanel();
        this.getViewport().setView(this.panel);
        this.setBackground(this.panel.getBackground());
        this.getViewport().setBackground(this.panel.getBackground());
    }

    class PropertyPanel
    extends JPanel
    implements Scrollable {
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            Font font = this.getFont();
            return font != null ? font.getSize() : 1;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return n == 0 ? rectangle.width : rectangle.height;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public PropertyPanel() {
            super(PropertySheet.this.bag);
        }
    }
}

