/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.propertySheet;

import lt.ktu.gmj.propertySheet.InvalidPropertyException;
import lt.ktu.gmj.propertySheet.PropertyProvider;
import lt.ktu.gmj.propertySheet.PropertyStringer;
import lt.ktu.gmj.propertySheet.StringablePropertyEditor;
import lt.monarch.function.Function;
import lt.monarch.function.FunctionParser;
import lt.monarch.function.LocalEnvironment;
import lt.monarch.function.SimpleEnvironment;
import lt.monarch.function.parser.ParseException;

public class FunctionEditor
extends StringablePropertyEditor
implements PropertyStringer {
    private PropertyProvider provider;

    public String getAsString() {
        Function function = (Function)this.provider.get();
        return function.body().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAsString(String string) throws InvalidPropertyException {
        try {
            Function function = (Function)this.provider.get();
            FunctionParser functionParser = new FunctionParser(new LocalEnvironment(new SimpleEnvironment(), function.parameters()));
            Function function2 = new Function(function.name(), function.parameters(), functionParser.parse(string));
            this.provider.set(function2);
            return;
        }
        catch (ParseException parseException) {
            throw new InvalidPropertyException("Invalid function");
        }
    }

    public FunctionEditor(PropertyProvider propertyProvider) {
        this.provider = propertyProvider;
        this.provider.addObserver(this);
        this.setStringer(this);
    }
}

