/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.analysis;

import java.awt.Event;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultRepository;
import lt.ktu.gmj.analysis.ResultFrame;
import lt.monarch.charts.Chart;
import lt.monarch.charts.ChartPoint;
import lt.monarch.charts.ChartPointProvider;
import lt.monarch.charts.ChartPointSeries;
import lt.monarch.charts.ConnectedSeries;
import lt.monarch.charts.Grid;
import lt.monarch.charts.InvisibleDot;
import lt.monarch.charts.MathAxisMapper;
import lt.monarch.charts.XAxis;
import lt.monarch.charts.YAxis;
import walras.LogAll;
import walras.WalrasModel;

public class WalrasProfit
extends ResultFrame
implements ChartPointProvider {
    public JButton btn_smooth;
    public JButton btn_wiener;
    public JButton btn_undo;
    public JButton btn_refresh;
    public double[] y_in;
    public double[] x_in;
    public double[] y_out;
    public int n;
    public int only_refresh;
    public int cur_point_nr;
    public double[] profx;
    public double[] profy;
    public double[] original_profy;
    public JTextField st;
    public JLabel control1;
    public JLabel control2;
    public JLabel clserved1;
    public JLabel clserved2;
    public JLabel clgone;
    public JLabel bestiter;
    public JLabel curriter;
    public JLabel diff;
    public JLabel profit1;
    public JLabel profit2;
    public JLabel v1;
    public JLabel v2;
    public JLabel bestX11;
    public JLabel bestY1;
    public JLabel bestP1;
    public JLabel bestX22;
    public JLabel bestY2;
    public JLabel bestP2;
    public JLabel bestX12;
    public JLabel bestX21;
    private static final String CMD_SMOOTH = "Smooth";
    private static final String CMD_WIENER = "Wiener";
    private static final String CMD_UNDO = "Undo";
    private static final String CMD_REFRESH = "Refresh";
    protected Chart chart;
    protected int projection;
    protected ChartPointSeries series;
    protected JComboBox projectionChoice;
    private WalrasModel gWalrasModel;

    public WalrasProfit() {
        super("Server Profit");
        System.out.println("Walras Profit. (Nerijus Remeikis, 1999, Kaunas)");
        this.setWalrasModel(WalrasModel.getWalrasModel());
        this.only_refresh = 0;
        this.chart = new Chart();
        this.getContentPane().add("Center", this.chart);
        this.projectionChoice = new JComboBox();
        this.projectionChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WalrasProfit.this.projection = WalrasProfit.this.projectionChoice.getSelectedIndex();
                WalrasProfit.this.setupChart();
            }
        });
        this.getContentPane().add("South", this.projectionChoice);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        jPanel2.setLayout(new GridLayout(1, 0, 0, 0));
        jPanel3.setLayout(new GridLayout(1, 0, 0, 0));
        jPanel4.setLayout(new GridLayout(1, 0, 0, 0));
        jPanel5.setLayout(new GridLayout(10, 1));
        jPanel.add("North", jPanel2);
        jPanel.add("North", jPanel3);
        jPanel.add("North", jPanel4);
        this.btn_smooth = new JButton(CMD_SMOOTH);
        this.btn_smooth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WalrasProfit.this.SmoothProfitCmd();
            }
        });
        jPanel5.add("North", this.btn_smooth);
        this.btn_wiener = new JButton(CMD_WIENER);
        this.btn_wiener.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WalrasProfit.this.WienerFilterCmd();
            }
        });
        jPanel5.add("North", this.btn_wiener);
        this.btn_undo = new JButton(CMD_UNDO);
        this.btn_undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WalrasProfit.this.Undo();
            }
        });
        jPanel5.add("North", this.btn_undo);
        this.btn_refresh = new JButton(CMD_REFRESH);
        this.btn_refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WalrasProfit.this.setupChart();
            }
        });
        jPanel5.add("North", this.btn_refresh);
        this.bestiter = new JLabel("0");
        this.curriter = new JLabel("0");
        this.diff = new JLabel("0");
        this.control1 = new JLabel("0");
        this.control2 = new JLabel("0");
        this.clserved1 = new JLabel("0");
        this.clserved2 = new JLabel("0");
        this.clgone = new JLabel("0");
        this.profit1 = new JLabel("0");
        this.profit2 = new JLabel("0");
        this.v1 = new JLabel("0");
        this.v2 = new JLabel("0");
        this.bestX11 = new JLabel("0");
        this.bestY1 = new JLabel("0");
        this.bestP1 = new JLabel("0");
        this.bestX22 = new JLabel("0");
        this.bestY2 = new JLabel("0");
        this.bestP2 = new JLabel("0");
        this.bestX12 = new JLabel("0");
        this.bestX21 = new JLabel("0");
        this.st = new JTextField("10", 6);
        this.curriter.setText(Integer.toString(this.getWalrasModel().curriter));
        this.bestiter.setText(Integer.toString(this.getWalrasModel().bestiter));
        this.diff.setText(Double.toString(this.getWalrasModel().bestf));
        this.control1.setText(Double.toString(this.getWalrasModel().bestcond1));
        this.control2.setText(Double.toString(this.getWalrasModel().bestcond2));
        this.clserved1.setText(Integer.toString(this.getWalrasModel().bestserved1));
        this.clserved2.setText(Integer.toString(this.getWalrasModel().bestserved2));
        this.clgone.setText(Integer.toString(this.getWalrasModel().bestgone));
        this.profit1.setText(Double.toString(this.getWalrasModel().bestu1));
        this.profit2.setText(Double.toString(this.getWalrasModel().bestu2));
        this.v1.setText(Double.toString(this.getWalrasModel().bestv1));
        this.v2.setText(Double.toString(this.getWalrasModel().bestv2));
        this.bestX11.setText(Double.toString(this.getWalrasModel().bestX11));
        this.bestY1.setText(Double.toString(this.getWalrasModel().bestY1));
        this.bestP1.setText(Double.toString(this.getWalrasModel().bestP1));
        this.bestX22.setText(Double.toString(this.getWalrasModel().bestX22));
        this.bestY2.setText(Double.toString(this.getWalrasModel().bestY2));
        this.bestP2.setText(Double.toString(this.getWalrasModel().bestP2));
        this.bestX12.setText(Double.toString(this.getWalrasModel().bestX12));
        this.bestX21.setText(Double.toString(this.getWalrasModel().bestX21));
        jPanel2.add("North", new JLabel("F(x)="));
        jPanel2.add("North", this.diff);
        jPanel2.add("North", new JLabel("Best it="));
        jPanel2.add("North", this.bestiter);
        jPanel2.add("North", new JLabel("Curr it="));
        jPanel2.add("North", this.curriter);
        jPanel2.add("North", new JLabel("Test1="));
        jPanel2.add("North", this.control1);
        jPanel2.add("North", new JLabel("Test2="));
        jPanel2.add("North", this.control2);
        jPanel2.add("North", new JLabel("S="));
        jPanel2.add("North", this.st);
        jPanel3.add("North", new JLabel("Served1="));
        jPanel3.add("North", this.clserved1);
        jPanel3.add("North", new JLabel("Served2="));
        jPanel3.add("North", this.clserved2);
        jPanel3.add("North", new JLabel("Gone="));
        jPanel3.add("North", this.clgone);
        jPanel3.add("North", new JLabel("u1="));
        jPanel3.add("North", this.profit1);
        jPanel3.add("North", new JLabel("u2="));
        jPanel3.add("North", this.profit2);
        jPanel3.add("North", new JLabel("v1="));
        jPanel3.add("North", this.v1);
        jPanel3.add("North", new JLabel("v2="));
        jPanel3.add("North", this.v2);
        jPanel4.add("North", new JLabel("X11="));
        jPanel4.add("North", this.bestX11);
        jPanel4.add("North", new JLabel("Y1="));
        jPanel4.add("North", this.bestY1);
        jPanel4.add("North", new JLabel("P1="));
        jPanel4.add("North", this.bestP1);
        jPanel4.add("North", new JLabel("X22="));
        jPanel4.add("North", this.bestX22);
        jPanel4.add("North", new JLabel("Y2="));
        jPanel4.add("North", this.bestY2);
        jPanel4.add("North", new JLabel("P2="));
        jPanel4.add("North", this.bestP2);
        jPanel4.add("North", new JLabel("X12="));
        jPanel4.add("North", this.bestX12);
        jPanel4.add("North", new JLabel("X21="));
        jPanel4.add("North", this.bestX21);
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("East", jPanel5);
    }

    public void CalculateOutput() {
        double[] dArray = new double[]{this.getWalrasModel().bestX11, this.getWalrasModel().bestY1, this.getWalrasModel().bestP1, this.getWalrasModel().bestX22, this.getWalrasModel().bestY2, this.getWalrasModel().bestP2, this.getWalrasModel().bestX12, this.getWalrasModel().bestX21};
        if (this.projection == 0) {
            int n = 0;
            while (n < this.PointCnt()) {
                this.profy[n] = this.getLogAll((int)n).profit1;
                this.profx[n] = n;
                ++n;
            }
            return;
        }
        if (this.projection == 1) {
            int n = 0;
            while (n < this.PointCnt()) {
                this.profy[n] = this.getLogAll((int)n).profit2;
                this.profx[n] = n;
                ++n;
            }
            return;
        }
        int n = 0;
        double d = this.GetXMin(this.projection);
        while (d <= this.GetXMax(this.projection)) {
            dArray[this.GetDomN((int)this.projection)] = d;
            this.getWalrasModel().ProcessServers(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7]);
            this.profy[n] = this.getWalrasModel().getServerProfit(this.projection % 2);
            this.profx[n] = d;
            ++n;
            d += this.GetXStep(this.projection);
        }
    }

    public int GetDomN(int n) {
        if (n == 2) {
            return 0;
        }
        if (n == 3) {
            return 7;
        }
        if (n == 4) {
            return 6;
        }
        if (n == 5) {
            return 3;
        }
        if (n == 6) {
            return 1;
        }
        if (n == 7) {
            return 4;
        }
        if (n == 8) {
            return 2;
        }
        if (n == 9) {
            return 5;
        }
        System.out.println("ERROR: GetDomN");
        return 0;
    }

    public double GetXMax(int n) {
        if (n == 0) {
            return this.results.method().iterations() - 1;
        }
        if (n == 1) {
            return this.results.method().iterations() - 1;
        }
        if (n == 2) {
            return this.getWalrasModel().domain().max[0];
        }
        if (n == 3) {
            return this.getWalrasModel().domain().max[7];
        }
        if (n == 4) {
            return this.getWalrasModel().domain().max[6];
        }
        if (n == 5) {
            return this.getWalrasModel().domain().max[3];
        }
        if (n == 6) {
            return this.getWalrasModel().domain().max[1];
        }
        if (n == 7) {
            return this.getWalrasModel().domain().max[4];
        }
        if (n == 8) {
            return this.getWalrasModel().domain().max[2];
        }
        if (n == 9) {
            return this.getWalrasModel().domain().max[5];
        }
        return 0.0;
    }

    public double GetXMin(int n) {
        if (n == 0) {
            return 0.0;
        }
        if (n == 1) {
            return 0.0;
        }
        if (n == 2) {
            return this.getWalrasModel().domain().min[0];
        }
        if (n == 3) {
            return this.getWalrasModel().domain().min[7];
        }
        if (n == 4) {
            return this.getWalrasModel().domain().min[6];
        }
        if (n == 5) {
            return this.getWalrasModel().domain().min[3];
        }
        if (n == 6) {
            return this.getWalrasModel().domain().min[1];
        }
        if (n == 7) {
            return this.getWalrasModel().domain().min[4];
        }
        if (n == 8) {
            return this.getWalrasModel().domain().min[2];
        }
        if (n == 9) {
            return this.getWalrasModel().domain().min[5];
        }
        return 0.0;
    }

    public double GetXStep(int n) {
        if (n == 0) {
            return 1.0;
        }
        if (n == 1) {
            return 1.0;
        }
        if (n == 2) {
            return this.getWalrasModel().X1Step;
        }
        if (n == 3) {
            return this.getWalrasModel().X1Step;
        }
        if (n == 4) {
            return this.getWalrasModel().X2Step;
        }
        if (n == 5) {
            return this.getWalrasModel().X2Step;
        }
        if (n == 6) {
            return this.getWalrasModel().Y1Step;
        }
        if (n == 7) {
            return this.getWalrasModel().Y2Step;
        }
        if (n == 8) {
            return this.getWalrasModel().P1Step;
        }
        if (n == 9) {
            return this.getWalrasModel().P2Step;
        }
        return 0.0;
    }

    public double GetYMax() {
        if (this.profy.length < 1) {
            return 1.0;
        }
        double d = -9999.0;
        int n = 0;
        while (n < this.profy.length) {
            if (this.profy[n] > d) {
                d = this.profy[n];
            }
            ++n;
        }
        return d;
    }

    public double GetYMin() {
        if (this.profy.length < 1) {
            return 0.0;
        }
        double d = 9999.0;
        int n = 0;
        while (n < this.profy.length) {
            if (this.profy[n] < d) {
                d = this.profy[n];
            }
            ++n;
        }
        return d;
    }

    public int PointCnt() {
        this.getWalrasModel().pointnum[0] = this.results.resultCount();
        this.getWalrasModel().pointnum[1] = this.results.resultCount();
        return this.getWalrasModel().pointnum[this.projection];
    }

    public void SmoothProfit() {
        int n = 0;
        while (n < this.n) {
            double d;
            double d2 = this.y_in[n];
            double d3 = this.y_in[n];
            double d4 = this.y_in[n];
            if (n - 1 > 0) {
                d2 = this.y_in[n - 1];
            }
            if (n + 1 < this.n) {
                d4 = this.y_in[n + 1];
            }
            this.y_out[n] = d = (d2 + d3 + d4) / 3.0;
            ++n;
        }
    }

    public synchronized void SmoothProfitCmd() {
        this.n = Math.min(this.profx.length, this.profy.length);
        this.y_in = new double[this.n];
        this.y_out = new double[this.n];
        this.x_in = new double[this.n];
        int n = 0;
        while (n < this.n) {
            this.x_in[n] = this.profx[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.n) {
            this.y_in[n2] = this.profy[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.n) {
            this.original_profy[n3] = this.profy[n3];
            ++n3;
        }
        this.SmoothProfit();
        int n4 = 0;
        while (n4 < this.n) {
            this.profy[n4] = this.y_out[n4];
            ++n4;
        }
        this.only_refresh = 1;
        this.setupChart();
        this.only_refresh = 0;
    }

    public synchronized void Undo() {
        int n = 0;
        while (n < this.original_profy.length) {
            this.profy[n] = this.original_profy[n];
            ++n;
        }
        this.only_refresh = 1;
        this.setupChart();
        this.only_refresh = 0;
    }

    public void WienerFilter() {
        double d;
        double[] dArray = new double[this.n];
        double[] dArray2 = new double[this.n];
        double d2 = new Double(this.st.getText());
        double d3 = 1.0;
        dArray[0] = 1.0;
        int n = 1;
        while (n < this.n) {
            d = Math.abs(this.x_in[n] - this.x_in[n - 1]);
            if (d2 == 0.0) {
                System.out.println("division by 0. (1)");
            }
            dArray[n] = (d2 * dArray[n - 1] + d * d3) / d2;
            d3 += dArray[n];
            ++n;
        }
        d = 0.0;
        dArray2[this.n - 1] = 1.0;
        int n2 = this.n - 2;
        while (n2 >= 0) {
            double d4 = Math.abs(this.x_in[n2] - this.x_in[n2 + 1]);
            d += dArray2[n2 + 1];
            if (d2 == 0.0) {
                System.out.println("division by 0. (2)");
            }
            dArray2[n2] = (d2 * dArray2[n2 + 1] + d4 * d) / d2;
            --n2;
        }
        int n3 = 0;
        while (n3 < this.n) {
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            int n4 = 0;
            while (n4 <= n3) {
                d5 += dArray[n4] * this.y_in[n4];
                d6 += dArray[n4];
                ++n4;
            }
            int n5 = n3 + 1;
            while (n5 < this.n) {
                d7 += dArray2[n5] * this.y_in[n5];
                d8 += dArray2[n5];
                ++n5;
            }
            double d9 = d6 + dArray[n3] * d8 / dArray2[n3];
            if (d9 == 0.0) {
                System.out.println("division by 0. (3)");
            }
            if (dArray2[n3] == 0.0) {
                System.out.println("division by 0. (4)");
            }
            this.y_out[n3] = (d5 + dArray[n3] * d7 / dArray2[n3]) / d9;
            ++n3;
        }
    }

    public synchronized void WienerFilterCmd() {
        this.n = Math.min(this.profx.length, this.profy.length);
        this.y_in = new double[this.n];
        this.y_out = new double[this.n];
        this.x_in = new double[this.n];
        int n = 0;
        while (n < this.n) {
            this.x_in[n] = this.profx[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.n) {
            this.y_in[n2] = this.profy[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.n) {
            this.original_profy[n3] = this.profy[n3];
            ++n3;
        }
        this.WienerFilter();
        int n4 = 0;
        while (n4 < this.n) {
            this.profy[n4] = this.y_out[n4];
            ++n4;
        }
        this.only_refresh = 1;
        this.setupChart();
        this.only_refresh = 0;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.projectionChoice) {
            this.projection = this.projectionChoice.getSelectedIndex();
            this.setupChart();
        }
        if (event.target == this.btn_smooth) {
            this.SmoothProfitCmd();
        }
        if (event.target == this.btn_wiener) {
            this.WienerFilterCmd();
        }
        if (event.target == this.btn_undo) {
            this.Undo();
        }
        if (event.target == this.btn_refresh) {
            this.setupChart();
        }
        return false;
    }

    public void finalResult(ResultRepository resultRepository) {
        this.newProgressResult(resultRepository);
    }

    public LogAll getLogAll(int n) {
        if (this.getWalrasModel().mylog.size() > n) {
            return (LogAll)this.getWalrasModel().mylog.elementAt(n);
        }
        return new LogAll(0.0, 0.0);
    }

    private WalrasModel getWalrasModel() {
        return this.gWalrasModel;
    }

    public synchronized void newLog(ResultRepository resultRepository) {
        this.chart.repaint();
    }

    public void newProgressResult(ResultRepository resultRepository) {
        this.curriter.setText(Integer.toString(this.getWalrasModel().curriter));
        this.bestiter.setText(Integer.toString(this.getWalrasModel().bestiter));
        this.diff.setText(Double.toString(this.getWalrasModel().bestf));
        this.control1.setText(Double.toString(this.getWalrasModel().bestcond1));
        this.control2.setText(Double.toString(this.getWalrasModel().bestcond2));
        this.clserved1.setText(Integer.toString(this.getWalrasModel().bestserved1));
        this.clserved2.setText(Integer.toString(this.getWalrasModel().bestserved2));
        this.clgone.setText(Integer.toString(this.getWalrasModel().bestgone));
        this.profit1.setText(Double.toString(this.getWalrasModel().bestu1));
        this.profit2.setText(Double.toString(this.getWalrasModel().bestu2));
        this.v1.setText(Double.toString(this.getWalrasModel().bestv1));
        this.v2.setText(Double.toString(this.getWalrasModel().bestv2));
        this.bestX11.setText(Double.toString(this.getWalrasModel().bestX11));
        this.bestY1.setText(Double.toString(this.getWalrasModel().bestY1));
        this.bestP1.setText(Double.toString(this.getWalrasModel().bestP1));
        this.bestX22.setText(Double.toString(this.getWalrasModel().bestX22));
        this.bestY2.setText(Double.toString(this.getWalrasModel().bestY2));
        this.bestP2.setText(Double.toString(this.getWalrasModel().bestP2));
        this.bestX12.setText(Double.toString(this.getWalrasModel().bestX12));
        this.bestX21.setText(Double.toString(this.getWalrasModel().bestX21));
        this.setupChart();
    }

    public synchronized void newResult(ResultRepository resultRepository) {
        this.curriter.setText(Integer.toString(this.getWalrasModel().curriter));
    }

    public ChartPoint point(int n) {
        this.cur_point_nr = n;
        return this.pointFromResult(this.results.resultAt(0));
    }

    public int pointCount() {
        return Math.min(this.profx.length, this.profy.length);
    }

    protected ChartPoint pointFromResult(Result result) {
        double d = this.profx[this.cur_point_nr];
        double d2 = this.profy[this.cur_point_nr];
        InvisibleDot invisibleDot = new InvisibleDot(new Double(d), new Double(d2));
        return invisibleDot;
    }

    public synchronized void prepare(ResultRepository resultRepository) {
        super.prepare(resultRepository);
        String[] stringArray = new String[]{"1-st server profit (iteration)", "2-nd server profit (iteration)", "1-st server profit (x11)", "2-nd server profit (x21)", "1-st server profit (x12)", "2-nd server profit (x22)", "1-st server profit (y1)", "2-nd server profit (y2)", "1-st server profit (p1)", "2-nd server profit (p2)"};
        int n = 0;
        while (n < stringArray.length) {
            this.projectionChoice.addItem(stringArray[n]);
            ++n;
        }
        this.setupChart();
        this.results.addObserver(this);
        this.show();
    }

    private void setWalrasModel(WalrasModel walrasModel) {
        this.gWalrasModel = walrasModel;
    }

    protected synchronized void setupChart() {
        double d;
        Vector<ChartPointSeries> vector = new Vector<ChartPointSeries>();
        MathAxisMapper mathAxisMapper = new MathAxisMapper();
        MathAxisMapper mathAxisMapper2 = new MathAxisMapper();
        XAxis xAxis = new XAxis(mathAxisMapper2);
        YAxis yAxis = new YAxis(mathAxisMapper);
        this.series = new ConnectedSeries(this, xAxis, yAxis);
        Grid grid = new Grid(xAxis, yAxis);
        String[] stringArray = new String[]{"U1", "U2"};
        yAxis.setLabel(stringArray[this.projection % 2]);
        String[] stringArray2 = new String[]{"it", "it", "x11", "x21", "x12", "x22", "y1", "y2", "p1", "p2"};
        xAxis.setLabel(stringArray2[this.projection]);
        if (this.only_refresh == 0) {
            this.profx = new double[this.PointCnt()];
            this.profy = new double[this.PointCnt()];
            this.original_profy = new double[this.PointCnt()];
            this.CalculateOutput();
        }
        this.cur_point_nr = 0;
        double d2 = this.GetYMin();
        if (d2 == (d = this.GetYMax())) {
            d2 -= 1.0;
            d += 1.0;
        }
        mathAxisMapper.range.setRange(d2, d);
        mathAxisMapper2.range.setRange(this.GetXMin(this.projection), this.GetXMax(this.projection));
        vector.addElement(this.series);
        xAxis.prepare();
        yAxis.prepare();
        this.chart.setup(vector);
        this.chart.setLeftAxis(yAxis);
        this.chart.setXAxis(xAxis);
        this.chart.setGrid(grid);
        this.chart.repaint();
    }
}

