/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.analysis;

import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultRepository;
import lt.ktu.gmj.analysis.ResultFrame;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.Grid;
import lt.monarch.chart.MathAxisMapper;
import lt.monarch.chart.chart2D.AbstractChartPointProvider;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.Chart2D;
import lt.monarch.chart.chart2D.ChartPoint;
import lt.monarch.chart.chart2D.ConnectedSeries;
import lt.monarch.chart.chart2D.InvisibleDot;
import lt.monarch.swing.JChartPanel;

public class Convergence
extends ResultFrame {
    protected Chart2D chart = new Chart2D();
    protected ConnectedSeries series;
    protected Provider provider;

    public Convergence() {
        super("Convergence");
        this.getContentPane().add("Center", new JChartPanel(this.chart));
    }

    public void finalResult(ResultRepository resultRepository) {
        this.newProgressResult(resultRepository);
    }

    public void newProgressResult(ResultRepository resultRepository) {
        this.provider.newResult(resultRepository.lastResult());
    }

    public void newResult(ResultRepository resultRepository) {
    }

    public void prepare(ResultRepository resultRepository) {
        super.prepare(resultRepository);
        this.setupChart();
        this.show();
        resultRepository.addObserver(this);
    }

    protected void setupChart() {
        this.provider = new Provider();
        MathAxisMapper mathAxisMapper = new MathAxisMapper();
        MathAxisMapper mathAxisMapper2 = new MathAxisMapper();
        Axis2DX axis2DX = new Axis2DX(mathAxisMapper2);
        Axis2DY axis2DY = new Axis2DY(mathAxisMapper);
        this.series = new ConnectedSeries(this.provider, axis2DX, axis2DY);
        Grid grid = new Grid(axis2DX, axis2DY);
        axis2DY.setLabel("f(x)");
        axis2DX.setLabel("Iteration");
        mathAxisMapper.range.setRange(this.results.minValue(), this.results.maxValue());
        mathAxisMapper2.range.setRange(0.0, this.results.method().iterations());
        this.chart.reset();
        this.chart.setLAxis(axis2DY);
        this.chart.setXAxis(axis2DX);
        this.chart.setObjects(new ChartObject[]{grid, axis2DX, axis2DY, this.series});
        this.chart.invalidate();
    }

    class Provider
    extends AbstractChartPointProvider {
        Provider() {
        }

        public void newResult(Result result) {
            ChartPoint chartPoint = this.pointFromResult(result);
            if (chartPoint.registerOn(Convergence.this.series)) {
                this.firePointsChanged();
            }
            this.firePointAdded(chartPoint);
        }

        public ChartPoint point(int n) {
            return n != 0 ? this.pointFromResult(Convergence.this.results.progressResultAt(n - 1)) : new InvisibleDot(new Double(0.0), new Double(Convergence.this.results.maxValue()));
        }

        public int pointCount() {
            return Convergence.this.results.progressResultCount() + 1;
        }

        protected ChartPoint pointFromResult(Result result) {
            InvisibleDot invisibleDot = new InvisibleDot(new Double(result.iteration), new Double(result.value));
            return invisibleDot;
        }
    }
}

