/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj;

import lt.ktu.gmj.Customizable;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.propertySheet.DoubleArrayProvider;
import lt.ktu.gmj.propertySheet.DoubleRangeProperty;
import lt.ktu.gmj.propertySheet.Header;
import lt.ktu.gmj.propertySheet.PropertyManager;

public abstract class Domain
implements Customizable {
    public double[] min = new double[this.dimensions().length];
    public double[] max = new double[this.dimensions().length];
    public Point defaultPoint = new Point(this);

    public abstract String[] dimensions();

    public void customize(PropertyManager propertyManager) {
        String[] stringArray = new String[]{"Min", "Default", "Max"};
        propertyManager.add(new Header("Dimension", stringArray));
        int n = 0;
        while (n < this.dimensions().length) {
            propertyManager.add(new DoubleRangeProperty(this.dimensions()[n] + " (x" + (n + 1) + ")", new DoubleArrayProvider(this.min, n), new DoubleArrayProvider(this.defaultPoint.x, n), new DoubleArrayProvider(this.max, n)));
            ++n;
        }
    }

    public double constraintAt(int n, Point point) {
        return 1.0;
    }

    public final void normalizePoint(Point point) {
        int n = 0;
        while (n < point.x.length) {
            point.x[n] = point.x[n] * (this.max[n] - this.min[n]) + this.min[n];
            ++n;
        }
    }
}

