package lt.ktu.gmj.tasks;

import lt.ktu.gmj.*;
import lt.ktu.gmj.propertySheet.*;
import lt.ktu.HostNameRetriever;

import drm.signal.neuro.*;

import java.util.Vector;
import java.net.URL;
import java.net.URLConnection;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * <p>Title: Optimizavimo Metodai</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class NeuroNet extends AbstractTask {
  private NeuroNetDomain domain = new NeuroNetDomain();
  private TestObject testObject = new TestObject();

  public NeuroNet() {
    setDefaults();
  }

  public void init() {
    try {
      URL tmyurl = new URL(fileName);
      System.out.println("Reading data from: " + tmyurl.getHost() + tmyurl.getFile());
      URLConnection tmycon = tmyurl.openConnection();
      System.out.println("Data type: " + tmycon.getContentType() + " with size: " + tmycon.getContentLength());
      InputStream tis = tmycon.getInputStream();
      Vector testVector = SignalStream.loadLearnFile(new InputStreamReader(tis));
      testObject.setTestVector(testVector);
      Vector[] first = (Vector[])testVector.get(0);
      int inputs = first[0].size();
      int outputs = first[1].size();
      System.out.println("Learn file loaded (inputs=" + String.valueOf(inputs) +
          "; outputs=" + String.valueOf(outputs) + ")");
      int wc = 0;
      Class clas = SimpleParceptron.class;
      switch (neuronTypeChoice) {
        case 0 :
          clas = SimpleParceptron.class;
          break;
        case 1 :
          clas = ExponentialParceptron.class;
          break;
        case 2 :
          clas = HTangentParceptron.class;
          break;
        case 3 :
          clas = QuadFunctionParceptron.class;
          break;
      }
      switch (nnTypeChoice) {
        case 0 :
          testObject.testObject = new NeuroNetSingleLayer(inputs, outputs, clas);
          wc = inputs * outputs;
          System.out.println("Single Layer Neural Network loaded (" +
              String.valueOf(wc) + " connections)");
          break;
        case 1 :
          testObject.testObject = new NeuroNetTwoLayers(inputs, outputs, outputs, clas);
          wc = inputs * (inputs + outputs);
          System.out.println("Two Layer Neural Network loaded (" +
              String.valueOf(wc) + " connections)");
          break;
      }
      domain.update(wc, 0, -1, 1);
    }
    catch (Exception ex) {
      System.err.println("Failed to init NeuroNet");
      ex.printStackTrace();
    }
  }

  public Domain domain() {
    return domain;
  }

  public double f(Point p) {
//System.out.println("starting f");
    if ((testObject.getTestVector() == null) ||
        (testObject.getTestVector().size() == 0)) init();
    double rez = testObject.test(p.x);
//System.out.println("rez: " + rez);
    return rez;
  }

  public int nnTypeChoice = 0;
  public int neuronTypeChoice = 0;
  public String fileName = "";

  public void setDefaults() {
    switch (nnTypeChoice) {
      case 0 :
        fileName = HostNameRetriever.getApplet().getCodeBase().toString()
            + "/neuro1.txt";
        break;
      case 1 :
        fileName = HostNameRetriever.getApplet().getCodeBase().toString()
            + "/neuro2.txt";
        break;
    }
  }

  public void customize(PropertyManager manager) {
    manager.add(new ChoiceProperty("NN type:",
        new NeuroNetChoiceProvider(this, "nnTypeChoice"),
        new String[]{"Single layer network", "Two layers network"}));
    manager.add(new ChoiceProperty("Neuron type:",
        new NeuroNetChoiceProvider(this, "neuronTypeChoice"),
        new String[]{"Simple parceptron", "Exponential function parceptron",
          "HyperbTangent function parceptron", "Quad function parceptron"}));
    manager.add(new UrlProperty("Learning file:", new FieldProvider(this, "fileName")));
  }

}