package lt.ktu.gmj.tasks;

import drm.genetics.*;
import drm.genetics.simple.DoubleGene;

import java.util.Random;

/**
 * <p>Title: Optimizavimo Metodai</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class KnapGen2Individual extends AbstractIndividual {
  protected Random random = new Random();

  public KnapGen2Individual(float[] object_cost, float[] object_weight,
      double[] object_ratio, int number_of_objects,
      double total_weight) {
    this.object_cost = object_cost;
    this.object_weight = object_weight;
    this.object_ratio = object_ratio;
    this.number_of_objects = number_of_objects;
    this.total_weight = total_weight;
  }

  protected float[] object_cost;
  protected float[] object_weight;
  protected double[] object_ratio;
  protected int number_of_objects;
  protected double total_weight;

  private double calculation(double[] norm_point)
  {
      double weight = 0.0D;
      double cost = 0.0D;
      double maxh = -1D;
      double hsum = 0.0D;
      int maxi = 0;
      int[] object_taken = new int[number_of_objects];

      for(int n = number_of_objects; n > 0; n--)
      {
          for(int i = 0; i < number_of_objects; i++)
              if((object_taken[i] == 0) && (maxh < object_ratio[i]))
              {
                  maxh = object_ratio[i];
                  maxi = i;
              }

          hsum = 0.0D;
          for(int i = 0; i < number_of_objects; i++)
              if(object_taken[i] == 0)
                  hsum += object_ratio[i];

          hsum = 1.0D / hsum;
          double eps = random.nextDouble();
          double r = 0.0D;
          for(int i = 0; i < number_of_objects; i++)
          {
            if (object_taken[i] == 0)
              r += (1.0D / (double)n) * norm_point[0] +
                  hsum * norm_point[1] * object_ratio[i] +
                  norm_point[2] * (double)(i != maxi ? 0 : 1);
            if (r <= eps)
              continue;
            weight += object_weight[i];
            if (weight > total_weight)
              return cost;
            cost += object_cost[i];
            object_taken[i] = 1;
            break;
          }

      }
      return cost;
  }

  public double updateWeight() {
    double[] p = new double[3];
    double sum = 0;
    for (int i=0; i<3; i++) {
      p[i] = ((DoubleGene)genome[i]).get();
      sum += p[i];
    }
    if (sum == 0);// for (int i=0; i<3; i++) p[i] = 1/3;
    else for (int i=0; i<3; i++) p[i] /= sum;
    weight = calculation(p);
    return weight;
  }

  public Individual copy() {
    KnapGen2Individual ind = new KnapGen2Individual(object_cost, object_weight,
        object_ratio, number_of_objects, total_weight);
    ind.weight = weight;
    ind.accessGenome(getGenome());
    return ind;
  }
}