package lt.ktu.gmj.tasks;

import drm.genetics.AbstractTask;
import drm.genetics.Individual;
import drm.genetics.Crossover;
import drm.genetics.Gene;
import drm.genetics.simple.*;
import drm.genetics.advanced.*;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Random;

/**
 * <p>Title: Optimizavimo Metodai</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class KnapGen2GenTask extends AbstractTask {
  public KnapGen2GenTask(String url, double total_weight,
      int mutationType, double percentMutating, int mutationLevel,
      int crossoverType, int crossoverStyle, int crossoverLevel) {

    try {
      this.total_weight = total_weight;
      input(url);

      minWeight = Double.POSITIVE_INFINITY;

      switch (mutationType) {
        case 0 :
          mutation = new SingleGeneMutation();
          break;
        case 1 :
          mutation = new SimpleMutation(percentMutating);
          break;
        case 2 :
          mutation = new BestSelMutation(percentMutating, mutationLevel);
          break;
      }

      switch (crossoverType) {
        case 0 :
          crossover = new SimpleCrossover();
          break;
        case 1 :
          crossover = new BestSelCrossover(crossoverLevel);
          break;
      }
      switch (crossoverStyle) {
        case 0 :
          crossover.setType(Crossover.TYPE_SINGLE_POINT);
          break;
        case 1 :
          crossover.setType(Crossover.TYPE_TWO_POINTS);
          break;
        case 2 :
          crossover.setType(Crossover.TYPE_RANDOM);
          break;
      }
    }
    catch (Exception ex) {
      System.err.println("Failed on Genetics task initialization");
      ex.printStackTrace();
    }
  }

  protected int indCount = 2;

  public Individual[] createIndividuals() {
    Random random = new Random(12345);
    if (indCount < 2) indCount = 2;
    int size = 3;
    Gene[] genom = new Gene[size];
    Individual[] inds = new Individual[indCount];
    for (int i = 0; i < indCount; i++) {
      for (int j = 0; j < size; j++) genom[j] = new DoubleGene(random.nextDouble(), 0, 1);
      KnapGen2Individual uin = new KnapGen2Individual(object_cost,
          object_weight, object_ratio, number_of_objects,
          total_weight);
      uin.setGenome(genom);
      inds[i] = uin;
    }
    return inds;
  }

  protected float[] object_cost;
  protected float[] object_weight;
  protected double[] object_ratio;
  protected int number_of_objects;
  protected double total_weight;
//  protected double[] Wealth;

  private void input(String url)
      throws MalformedURLException, IOException
  {
      int num = 0;
      number_of_objects = 0;
      URL tmyurl = new URL(url);
      System.out.println("Reading data from: " + tmyurl.getHost() + tmyurl.getFile());
      URLConnection tmycon = tmyurl.openConnection();
      System.out.println("Data type: " + tmycon.getContentType() + " with size: " + tmycon.getContentLength());
      InputStream tis = tmycon.getInputStream();
      BufferedReader tids = new BufferedReader(new InputStreamReader(tis));
      tids.readLine();
      String data_line;
      while((data_line = tids.readLine()) != null)
      {
          StringTokenizer st = new StringTokenizer(data_line);
          st.nextToken();
          st.nextToken();
          number_of_objects += Integer.valueOf(st.nextToken()).intValue();
          num++;
      }
      System.out.println("Object types: " + num + " and total ammount: " + number_of_objects);
      tids.close();
      tis.close();
      object_cost = new float[number_of_objects];
      object_weight = new float[number_of_objects];
      object_ratio = new double[number_of_objects];
//      Wealth = new double[Initialpopulation];
      URLConnection mycon = tmyurl.openConnection();
      InputStream is = mycon.getInputStream();
      BufferedReader ids = new BufferedReader(new InputStreamReader(is));
      ids.readLine();
      num = 0;
      while((data_line = ids.readLine()) != null)
      {
          StringTokenizer st = new StringTokenizer(data_line);
          float f1 = Float.valueOf(st.nextToken()).floatValue();
          float f2 = Float.valueOf(st.nextToken()).floatValue();
          int k = Integer.valueOf(st.nextToken()).intValue();
          for(int i = 0; i < k; i++)
          {
              object_weight[num] = f1;
              object_cost[num] = f2;
              object_ratio[num] = f2 / f1;
              num++;
          }

      }
      ids.close();
      is.close();
      System.out.println("Data ready...");
  }
}