package lt.ktu.gmj.tasks;

import lt.ktu.gmj.AbstractTask;
import lt.ktu.gmj.Domain;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.propertySheet.*;
import lt.ktu.HostNameRetriever;

import drm.genetics.Mutation;
import drm.genetics.Crossover;
import drm.genetics.Runner;
import drm.genetics.Task;
import drm.genetics.simple.*;

import java.util.TreeSet;

/**
 * <p>Title: Optimizavimo Metodai</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class KnapGen2 extends AbstractTask {
  protected KnapGen2Domain domain = new KnapGen2Domain();

  public KnapGen2() {
  }

  public String data_url = HostNameRetriever.getCodeBase() + "norveda.txt";
  public double total_weight = 10;
  public int iterations = 10;
  public int mutationType = 0;
  public double percentMutating = 0.05;
  public int mutationLevel = 2;
  public int crossoverType = 0;
  public int crossoverStyle = 0;
  public int crossoverLevel = 2;

  protected SimpleRunner runner;
  protected KnapGen2GenTask task = null;

  public Domain domain() {
    return domain;
  }

  protected void init() {
    runner = new SimpleRunner();
    task = new KnapGen2GenTask(data_url, total_weight,
      mutationType, percentMutating, mutationLevel,
      crossoverType, crossoverStyle, crossoverLevel);
  }

  public double f(Point p) {
    if (task == null) init();
    task.indCount = (int)p.x[0];
    runner.init(task);
    runner.setMutationProbability(p.x[1]);
    runner.setCrossoverProbability(p.x[2]);
    runner.setBestPassPercentage(p.x[3]);
    runner.step(iterations);
    KnapGen2Individual ind = (KnapGen2Individual)((TreeSet)runner.accessIndivids()).first();
    return -Math.max(0, ind.getWeight());
  }

  public void customize(PropertyManager manager) {
    manager.add(new DoubleProperty("Total Weight", new FieldProvider(this, "total_weight")));
    manager.add(new UrlProperty("URL of data file", new FieldProvider(this, "data_url")));

    manager.add(new IntProperty("Iterations", new FieldProvider(this, "iterations")));
//    manager.add(new IntProperty("Individuals", new FieldProvider(this, "indCount")));
    manager.add(new ChoiceProperty("Mutation type:", new FieldProvider(this, "mutationType"),
        new String[]{"Single gene mutation", "Simple partial mutation", "Searching best mutation"}));
    manager.add(new DoubleProperty("Mutating part", new FieldProvider(this, "percentMutating")));
    manager.add(new IntProperty("Mutation best search level", new FieldProvider(this, "mutationLevel")));
    manager.add(new ChoiceProperty("Crossover type:", new FieldProvider(this, "crossoverType"),
        new String[]{"Simple crossover", "Searching best crossover"}));
    manager.add(new ChoiceProperty("Crossover style:", new FieldProvider(this, "crossoverStyle"),
        new String[]{"Single point crossover", "Two points crossover", "Random crossover"}));
    manager.add(new IntProperty("Crossover best search level", new FieldProvider(this, "crossoverLevel")));
  }

}