package lt.ktu.gmj.methods;

import lt.ktu.gmj.*;
import lt.ktu.gmj.propertySheet.*;
import lt.ktu.gmj.ui.ResultSet;

import drm.genetics.simple.*;

import java.util.TreeSet;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class MethodGAopt extends AbstractMethod implements Task {
  public int BayesIterations = 10;
  public int BayesInitialPoints = 5;
  public int BayesGAIterations = 10;


  protected int iterations = 0;
  public double minValue = Double.NEGATIVE_INFINITY;
//  public double mutation = 0.3;
//  public double crossover = 0.5;
//  public double elites = 0.01;
  public int maxIterations = 100;
//  public int indCount = 10;
  public int mutationType = 0;
  public double percentMutating = 0.05;
  public int mutationLevel = 2;
  public int crossoverType = 0;
  public int crossoverStyle = 0;
  public int crossoverLevel = 2;

  public MethodGAopt() {
  }

  public int iterations() {
    return iterations;
  }

  public void customize(PropertyManager manager) {
    manager.add(new Header("", "Bayes options"));
    manager.add(new IntProperty("Iterations", new FieldProvider(this, "BayesIterations")));
    manager.add(new IntProperty("Initial points", new FieldProvider(this, "BayesInitialPoints")));
    manager.add(new IntProperty("GA iterations when optimized", new FieldProvider(this, "BayesGAIterations")));

    manager.add(new Header("", "adanced Genetic Algorithm options"));
    manager.add(new IntProperty("Iterations", new FieldProvider(this, "maxIterations")));
    manager.add(new DoubleProperty("Stop if <=", new FieldProvider(this, "minValue")));
//    manager.add(new IntProperty("Individuals", new FieldProvider(this, "indCount")));
//    manager.add(new DoubleProperty("Mutation prob.", new FieldProvider(this, "mutation")));
//    manager.add(new DoubleProperty("Crossover prob.", new FieldProvider(this, "crossover")));
//    manager.add(new DoubleProperty("Elites perc.", new FieldProvider(this, "elites")));
    manager.add(new ChoiceProperty("Mutation type:", new FieldProvider(this, "mutationType"),
        new String[]{"Single gene mutation", "Simple partial mutation", "Searching best mutation"}));
    manager.add(new DoubleProperty("Mutating part", new FieldProvider(this, "percentMutating")));
    manager.add(new IntProperty("Mutation best search level", new FieldProvider(this, "mutationLevel")));
    manager.add(new ChoiceProperty("Crossover type:", new FieldProvider(this, "crossoverType"),
        new String[]{"Simple crossover", "Searching best crossover"}));
    manager.add(new ChoiceProperty("Crossover style:", new FieldProvider(this, "crossoverStyle"),
        new String[]{"Single point crossover", "Two points crossover", "Random crossover"}));
    manager.add(new IntProperty("Crossover best search level", new FieldProvider(this, "crossoverLevel")));
    manager.add(new Header("", "Mantas Balnys, KTU"));
  }

  private SimpleRunner runner;
  private MethodGATask taskGA;
  private Result bestResult = new Result();
  private ResultLogger resultLog;

  public Result run(ResultLogger log, Task task) {
    iterations = 0;
    resultLog = log;

    runner = new SimpleRunner();
    taskGA = new MethodGATask(task, 10,
      mutationType, percentMutating, mutationLevel,
      crossoverType, crossoverStyle, crossoverLevel);

    Bayes bayes = new Bayes();
    bayes.initialPoints = BayesInitialPoints;
    bayes.iterations = BayesIterations;
    Result bayesRez = bayes.run(new ResultSet(bayes, this), this);

    System.out.println("Bayes optimization rezults:");
    System.out.println("population:" + (int)bayesRez.point.x[0]);
    System.out.println("mutation:  " + bayesRez.point.x[1]);
    System.out.println("crossover: " + bayesRez.point.x[2]);
    System.out.println("elites:    " + bayesRez.point.x[3]);
    System.out.println();

    taskGA.indCount = (int)bayesRez.point.x[0];
    runner.init(taskGA);
    runner.setMutationProbability(bayesRez.point.x[1]);
    runner.setCrossoverProbability(bayesRez.point.x[2]);
    runner.setBestPassPercentage(bayesRez.point.x[3]);

    boolean testi = true;
    int maxiter = maxIterations + iterations;
    while ((iterations < maxiter)&&(testi)) {
      iterations++;
      runner.step();
      MethodGAIndividual best = (MethodGAIndividual)((java.util.TreeSet)runner.accessIndivids()).first();
      Result result = new Result(iterations, best.getPoint(), -best.getWeight());
      if (bestResult.value > result.value) bestResult = result;
//System.out.println(result.iteration + ": " + result.value + "; point = " + result.point);
      if (result.value <= minValue) testi = false;
      resultLog.log(result);
    }

    return bestResult;
  }

  private MethodGAoptDomain domain = new MethodGAoptDomain();

  public Domain domain() {
    return domain;
  }

  public double f(Point p) {
    taskGA.indCount = (int)p.x[0];
    runner.init(taskGA);
    runner.setMutationProbability(p.x[1]);
    runner.setCrossoverProbability(p.x[2]);
    runner.setBestPassPercentage(p.x[3]);
    runner.step(BayesGAIterations);
    iterations++;

    MethodGAIndividual ind = (MethodGAIndividual)((TreeSet)runner.accessIndivids()).first();
    Result result = new Result(iterations, ind.getPoint(), -ind.getWeight());
    if (bestResult.value > result.value) bestResult = result;
    resultLog.log(result);
    return -Math.max(0, ind.getWeight());
  }

}
