package lt.ktu.gmj.methods;

import drm.genetics.*;
import drm.genetics.simple.*;
import drm.genetics.advanced.*;
import lt.ktu.gmj.Task;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class MethodGATask extends AbstractTask {
  protected Task task;

  protected int indCount;

  public MethodGATask(Task task, int indCount,
      int mutationType, double percentMutating, int mutationLevel,
      int crossoverType, int crossoverStyle, int crossoverLevel) {

    this.task = task;
    this.indCount = indCount;
    minWeight = Double.POSITIVE_INFINITY;

    switch (mutationType) {
      case 0 :
        mutation = new SingleGeneMutation();
        break;
      case 1 :
        mutation = new SimpleMutation(percentMutating);
        break;
      case 2 :
        mutation = new BestSelMutation(percentMutating, mutationLevel);
        break;
    }

    switch (crossoverType) {
      case 0 :
        crossover = new SimpleCrossover();
        break;
      case 1 :
        crossover = new BestSelCrossover(crossoverLevel);
        break;
    }
    switch (crossoverStyle) {
      case 0 :
        crossover.setType(Crossover.TYPE_SINGLE_POINT);
        break;
      case 1 :
        crossover.setType(Crossover.TYPE_TWO_POINTS);
        break;
      case 2 :
        crossover.setType(Crossover.TYPE_RANDOM);
        break;
    }
  }

  public Individual[] createIndividuals() {
//    int size = task.domain().defaultPoint.x.length;
//    Gene[] genom = new Gene[size];
    Individual[] inds = new Individual[indCount];
    for (int i = 0; i < indCount; i++) {
      MethodGAIndividual uin = new MethodGAIndividual();
      uin.init(task);
      inds[i] = uin;
    }
    return inds;
  }

}
