package lt.ktu.gmj.methods;

import drm.genetics.simple.DoubleGene;
import lt.ktu.gmj.Task;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.Domain;
import java.util.Random;
import drm.genetics.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class MethodGAIndividual extends AbstractIndividual {
  protected Task task;
  protected Point point;
  protected Random random = new Random();

  public void setPoint(Point point) {
    this.point = new Point(point);
  }

  public Point getPoint() {
    return new Point(point);
  }

  public MethodGAIndividual() {
  }

  public void init(Task task) {
    this.task = task;
    Domain domain = task.domain();
    point = new Point(domain);
    genome = new DoubleGene[point.x.length];
    for (int i=0; i<genome.length; i++)
      genome[i] = new DoubleGene(domain.min[i] + random.nextDouble() *
          (domain.max[i] - domain.min[i]), domain.min[i], domain.max[i]);
    weight = -task.f(new Point(point));
  }

  protected void updatePoint() {
    for (int i=0; i<point.x.length; i++)
      point.x[i] = ((DoubleGene)genome[i]).get();
  }

  public double updateWeight() {
    updatePoint();
    weight = -task.f(new Point(point));
    return weight;
  }

  public Individual copy() {
    MethodGAIndividual ind = null;
    try {
      ind = new MethodGAIndividual();
      ind.task = task;
      ind.point = new Point(point);
      ind.accessGenome(getGenome());
      ind.weight = weight;
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return ind;
  }
/*
  public int compareTo(Object ind) {
    return -super.compareTo(ind);
  }
*/
}
