package lt.ktu.gmj.methods;

import lt.ktu.gmj.*;
import lt.ktu.gmj.propertySheet.*;

import drm.genetics.simple.*;
//import drm.genetics.Individual;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class MethodGA extends AbstractMethod {
  protected int iterations = 0;
  public double minValue = Double.NEGATIVE_INFINITY;
  public double mutation = 0.3;
  public double crossover = 0.5;
  public double elites = 0.01;
  public int maxIterations = 100;
  public int indCount = 10;
  public int mutationType = 0;
  public double percentMutating = 0.05;
  public int mutationLevel = 2;
  public int crossoverType = 0;
  public int crossoverStyle = 0;
  public int crossoverLevel = 2;

  public MethodGA() {
  }

  public int iterations() {
    return iterations;
  }

  public void customize(PropertyManager manager) {
    manager.add(new IntProperty("Iterations", new FieldProvider(this, "maxIterations")));
    manager.add(new DoubleProperty("Stop if <=", new FieldProvider(this, "minValue")));
    manager.add(new IntProperty("Individuals", new FieldProvider(this, "indCount")));
    manager.add(new DoubleProperty("Mutation prob.", new FieldProvider(this, "mutation")));
    manager.add(new DoubleProperty("Crossover prob.", new FieldProvider(this, "crossover")));
    manager.add(new DoubleProperty("Elites perc.", new FieldProvider(this, "elites")));
    manager.add(new ChoiceProperty("Mutation type:", new FieldProvider(this, "mutationType"),
        new String[]{"Single gene mutation", "Simple partial mutation", "Searching best mutation"}));
    manager.add(new DoubleProperty("Mutating part", new FieldProvider(this, "percentMutating")));
    manager.add(new IntProperty("Mutation best search level", new FieldProvider(this, "mutationLevel")));
    manager.add(new ChoiceProperty("Crossover type:", new FieldProvider(this, "crossoverType"),
        new String[]{"Simple crossover", "Searching best crossover"}));
    manager.add(new ChoiceProperty("Crossover style:", new FieldProvider(this, "crossoverStyle"),
        new String[]{"Single point crossover", "Two points crossover", "Random crossover"}));
    manager.add(new IntProperty("Crossover best search level", new FieldProvider(this, "crossoverLevel")));
    manager.add(new Header("", "Mantas Balnys, KTU"));
  }

  public Result run(ResultLogger log, Task task) {
    SimpleRunner runner = new SimpleRunner();
    MethodGATask taskGA = new MethodGATask(task, indCount,
      mutationType, percentMutating, mutationLevel,
      crossoverType, crossoverStyle, crossoverLevel);
    taskGA.indCount = indCount;
    runner.init(taskGA);
    runner.setMutationProbability(mutation);
    runner.setCrossoverProbability(crossover);
    runner.setBestPassPercentage(elites);

    Result result = null;
    boolean testi = true;
    for (iterations = 0; (iterations < maxIterations)&&(testi); iterations++) {
      runner.step();
      MethodGAIndividual best = (MethodGAIndividual)((java.util.TreeSet)runner.accessIndivids()).first();
      result = new Result(runner.getAge(), best.getPoint(), -best.getWeight());
      if (result.value <= minValue) testi = false;
      log.log(result);
    }

    return result;
  }

}
