package drm.test;

import drm.genetics.*;
import drm.genetics.simple.*;
import drm.genetics.advanced.*;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class UserTask extends AbstractTask {
  public UserTask() {
//    mutation = new SingleGeneMutation();
//    mutation = new SimpleMutation(0.1);
    mutation = new BestSelMutation(0.1, 3);
//    crossover = new SimpleCrossover(Crossover.TYPE_TWO_POINTS);
    crossover = new BestSelCrossover(Crossover.TYPE_RANDOM, 2);
    ((SimpleCrossover)crossover).DEBUG_CROSS = false;
    minWeight = -0.01;
  }

  public Individual[] createIndividuals() {
    int indCount = 10;
    int size = 4416;
    Gene[] genom = new Gene[size];
    Individual[] inds = new Individual[indCount];
    for (int i = 0; i < indCount; i++) {
      for (int j = 0; j < size; j++) genom[j] = new DoubleGene(Math.random() * 2 - 1, -2, 2);
      UserIndividual uin = new UserIndividual();
      uin.setGenome(genom);
      inds[i] = uin;
    }
    return inds;
  }

}