package drm.test;

import drm.genetics.*;
import drm.genetics.simple.*;

import drm.signal.neuro.*;
//import

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class UserIndividual extends AbstractIndividual {
  private TestObject testObject = new TestObject();

  public UserIndividual() {
    try {
      testObject.testObject = new NeuroNetSingleLayer(9, 9, SimpleParceptron.class);
      testObject.setTestVector(SignalStream.loadLearnFile("neuro1.txt"));
/*      testObject.testObject = new NeuroNetTwoLayers(64, 64, 5, SimpleParceptron.class);
      testObject.setTestVector(SignalStream.loadLearnFile("neuro3.txt"));*/
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  public double updateWeight() {
    double[] gen = new double[genome.length];
    for (int i = 0; i < gen.length; i++) gen[i] = ((DoubleGene)genome[i]).get();
    weight = -testObject.test(gen);
    return weight;
  }

  public String toString() {
    String out = "quality: " + String.valueOf(getWeight());
//    for (int i=0; i<genome.length; i++) out += genome[i].toString() + ";\t";
    return out;
  }
}