package drm.signal.neuro;

import java.util.*;
import drm.signal.*;

/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class TestObject {
  public long MAX_TEST_STEP = 1000;
  protected Vector test = null;
  protected Processor p = new Processor();
  public AbstractNeuroContainer testObject = null;

  public TestObject() {
  }

  public TestObject(Vector test) {
    setTestVector(test);
  }

  public void setTestVector(Vector test) {
    this.test = test;
  }

  public Vector getTestVector() {
    return test;
  }

  public double test(double[] weights) {
    double sum = 0;
    testObject.setAllWeights(weights);
    Iterator it = test.iterator();
    while (it.hasNext()) {
      testObject.setStep(0);
      testObject.clearSignals();
      Iterator its = testObject.in.iterator();
      while (its.hasNext()) ((Connector)its.next()).setChanged(true);
      Vector[] io = (Vector[])it.next();
      Iterator itt = io[0].iterator();
      int nr = 0;
      while (itt.hasNext()) {
        Signal s = new SimpleSignal(new NeuroValue(((Double)itt.next()).doubleValue()));
        testObject.setInSignal(nr, s);
        nr++;
      }

//System.out.println("START");
//System.out.println(testObject.in);
//System.out.println(testObject.out);
      p.proccess((Vector)testObject.in.clone(), MAX_TEST_STEP);
//System.out.println(testObject.in);
//System.out.println(testObject.out);

      sum += compare(testObject.out, io[1]);
    }
    return sum/test.size(); // nuo 0 iki 1
  }

  private double compare(Vector out, Vector req) {
    double sum = 0;
//System.out.print("CMP:");
    for (int i=0; i<out.size(); i++) {
      Signal outS = ((Connector)out.get(i)).getSignal();
      double outD = 0;
      try { outD = ((NeuroValue)outS.getValue()).value; } catch (Exception ex) { ex.printStackTrace(); }
      double reqD = ((Double)req.get(i)).doubleValue();
      sum += compare(outD, reqD);
    }
//System.out.print("=");
//System.out.println(sum/out.size());
    return sum/out.size(); // nuo 0 iki 1
  }

  private double compare(double out, double req) {
    double sub = req - out;
//System.out.print("(" + String.valueOf(req) + " - " + String.valueOf(out) + ") = " + String.valueOf(sub * sub));
    return sub * sub; // nuo 0 iki 1
  }
}