package drm.signal.neuro;

import java.util.Vector;
import drm.util.UString;
import java.io.*;

/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class SignalStream {
  public static Vector loadLearnFile(String fileName) throws FileNotFoundException {
    return loadLearnFile(new FileReader(fileName));
  }

  /**
   * Loads file of input and output signals
   * File format:
   * INPUTS:
   * double double ...
   * double ...
   * ...
   * END
   * OUTPUTS:
   * double ...
   * double ...
   * ...
   * END
   * INPUTS:
   * ...
   * END
   * ...
   *
   * @param fileName input file name
   * @return Vector of two Vectors (inputs, outputs) of Double
   * @throws FileNotFoundException
   */
  public static Vector loadLearnFile(Reader stream) {
    BufferedReader lr = new BufferedReader(stream);
    boolean testi = true;
    Vector out = new Vector();
    try {
      while (lr.ready()) {
        Vector sig[] = new Vector[2];
        sig[0] = readSignals("INPUTS:", lr);
        sig[1] = readSignals("OUTPUTS:", lr);
        out.add(sig);
//      if ((!lr.isEOF())||(sig[0].size() != 0)||(sig[1].size() != 0)) out.add(sig);
      }
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return out;
  }

  /**
   * Reads signal values from file after defined label is found, reads till not double value occures
   * @param label reads from file only after this label is found
   * @param lr file reader
   * @return Vector of Double values
   */
  private static Vector readSignals(String label, BufferedReader lr) {
    boolean testi = true;
    Vector sig = new Vector(25);
    while (testi) {
      String text = null;
      try { text = lr.readLine(); } catch (IOException ex) { testi = false; }
      if ((testi)&&(text.compareTo(label) == 0)) {
        while (testi) {
          String cols[] = null;
          try { cols = UString.parse(lr.readLine()); } catch (Exception ex) { testi = false; }
          if (testi) {
            for (int i=0; i<cols.length; i++) {
              try {
                Double d = Double.valueOf(cols[i]);
                sig.add(d);
              } catch (Exception ex) {
                testi = false;
                break;
              }
            }
          }
        }
      }
    }
    return sig;
  }

}