package drm.signal.neuro;

import drm.signal.*;
import java.util.*;

/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class NeuroNetTwoLayers extends AbstractNeuroContainer {
  public NeuroNetTwoLayers(int inputCount, int hidenCount, int outputCount, Class neuronType)
      throws IllegalAccessException, InstantiationException {

    Vector b1 = new Vector(inputCount);
    Vector b2 = new Vector(hidenCount);
    Vector b3 = new Vector(outputCount);
    for (int i=0; i<inputCount; i++) {
      AbstractBox btmp = new NullBox();
      neurons.add(btmp);
      b1.add(btmp);
      Connector cnt = new Connector(null, btmp);
      in.add(cnt);
    }
    for (int i=0; i<hidenCount; i++) {
      AbstractBox btmp = (AbstractBox)neuronType.newInstance();
      neurons.add(btmp);
      b2.add(btmp);
    }
    for (int i=0; i<outputCount; i++) {
      AbstractBox btmp = (AbstractBox)neuronType.newInstance();
      neurons.add(btmp);
      b3.add(btmp);
      Connector cnt = new Connector(btmp, null);
      out.add(cnt);
    }
    Iterator it1 = b1.iterator();
    while (it1.hasNext()) {
      AbstractBox box1 = (AbstractBox)it1.next();
      Iterator it2 = b2.iterator();
      while (it2.hasNext()) {
        AbstractBox box2 = (AbstractBox)it2.next();
        new Connector(box1, box2);
      }
    }
    it1 = b2.iterator();
    while (it1.hasNext()) {
      AbstractBox box1 = (AbstractBox)it1.next();
      Iterator it2 = b3.iterator();
      while (it2.hasNext()) {
        AbstractBox box2 = (AbstractBox)it2.next();
        new Connector(box1, box2);
      }
    }

  }

  protected void update() {
  }

}