package drm.signal.neuro;

import drm.signal.*;
import java.util.*;


/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public abstract class AbstractNeuroContainer extends AbstractBox {
  protected Vector neurons = new Vector();
  protected double weight[] = {};

  public void setAllWeights(double[] weights) throws ArrayIndexOutOfBoundsException {
    this.weight = (double[])weights.clone();
    Iterator it = neurons.iterator();
    int i = 0;
    while (it.hasNext()) {
      Object box = it.next();
      if (box instanceof AbstractNeuroBox) {
        AbstractNeuroBox anb = (AbstractNeuroBox)box;
        int size = anb.weight.length;
        double wt[] = new double[size];
        System.arraycopy(weight, i, wt, 0, size);
        anb.setWeights(wt);
        i += size;
      }
    }
  }

  public double[] getAllWeights() {
    return (double[])weight.clone();
  }

  public void setStep(long step) {
    super.setStep(step);
    Iterator it = neurons.iterator();
    while(it.hasNext()) ((AbstractBox)it.next()).setStep(step);
  }

  public void clearSignals() {
    Iterator it = neurons.iterator();
    while (it.hasNext()) ((AbstractBox)it.next()).clearSignals();
  }

}