package drm.signal.neuro;

import drm.signal.*;
import java.util.*;


/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public abstract class AbstractNeuroBox extends AbstractBox {
  protected double weight[] = {};

  public void setWeights(double[] weight) throws ArrayIndexOutOfBoundsException {
    if (weight.length != in.size()) throw new ArrayIndexOutOfBoundsException();
    this.weight = weight;
  }

  public void setWeight(int nr, double weight) throws ArrayIndexOutOfBoundsException {
    this.weight[nr] = weight;
  }

  public double getWeight(int nr) throws ArrayIndexOutOfBoundsException {
    return weight[nr];
  }

  public double[] getWeights() {
    return (double[])weight.clone();
  }

  public void setInputs(Connector[] con) {
    super.setInputs(con);
    weight = new double[con.length];
  }

  public int addInput(Connector con) {
    int out = super.addInput(con);
    double tmp[] = new double[out + 1];
    System.arraycopy(weight, 0, tmp, 0, weight.length);
    weight = tmp;
    return out;
  }

  public Connector remInput(int nr) throws ArrayIndexOutOfBoundsException {
    Connector out = super.remInput(nr);
    if (out != null) {
      double tmp[] = new double[weight.length - 1];
      System.arraycopy(weight, 0, tmp, 0, nr);
      System.arraycopy(weight, nr + 1, tmp, nr, weight.length - nr - 1);
      weight = tmp;
    }
    return out;
  }

  public boolean remInput(Connector con) {
    int nr = in.indexOf(con);
    boolean out = super.remInput(con);
    if (out) {
      double tmp[] = new double[weight.length - 1];
      System.arraycopy(weight, 0, tmp, 0, nr);
      System.arraycopy(weight, nr + 1, tmp, nr, weight.length - nr - 1);
      weight = tmp;
    }
    return out;
  }

  protected void update() {
    double sum = 0.0;
    for (int i=0; i<in.size(); i++)
      sum += (double)weight[i] * ((NeuroValue)((Connector)in.get(i)).getSignalValue()).value;
    double rez = function(sum);
    Signal s = new SimpleSignal(new NeuroValue(rez));
    s.setStep(step + 1);
    setOutSignal(s);
  }

  protected abstract double function(double sum);

}
