package drm.signal.logic;

import drm.signal.*;
import java.util.*;

/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class OrBox extends AbstractBox {
  public OrBox() {
  }

  protected void update() {
    LogicValue rez = new LogicValue(LogicValue.ZERO_SIGNAL);
    Iterator it = in.iterator();
    while ((it.hasNext())&&(rez.value != LogicValue.ONE_SIGNAL)) {
      Signal s = ((Connector)it.next()).getSignal();
      int val = LogicValue.X_SIGNAL;
      if (s != null) val = ((LogicValue)s.getValue()).value;
      if (rez.value == LogicValue.ZERO_SIGNAL) rez.value = val;
        else if ((rez.value == LogicValue.X_SIGNAL)&&(val != LogicValue.ZERO_SIGNAL))
          rez.value = val;
    }
    Signal s = new SimpleSignal(rez);
    s.setStep(step + 1);
    setOutSignal(s);
  }

}
