package drm.signal;

/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class SimpleSignal implements Signal {
  protected Object value = null;

  protected long step = MIN_STEP;

  public SimpleSignal() {
  }

  public SimpleSignal(Object value) {
    setValue(value);
  }

  public void setStep(long step) {
    this.step = step;
  }

  public long getStep() {
    return step;
  }

  public long incStep() {
    return ++step;
  }

  public void setValue(Object value) {
    this.value = value;
  }

  public Object getValue() {
    return value;
  }

  public boolean equals(Signal s) {
    if (s == null) return false;
    if (value == null) {
      if (s.getValue() == null) return true;
      else return false;
    } else return value.equals(s.getValue());
  }

  public Signal copy() {
    Signal s = null;
    try {
      s = (Signal)getClass().newInstance();
      s.setStep(step);
      s.setValue(value);
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return s;
  }

  public String toString() {
    String val = "null";
    if (value != null) val = value.toString();
    return "step:" + String.valueOf(step) + ",value:" + val;
  }
}