package drm.signal;

/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class Connector implements Simulation {
  protected AbstractBox in = null;
  protected AbstractBox out = null;
  protected Signal s = null;
  protected boolean changed = false;

  public Connector() {
  }

  public Connector(AbstractBox in, AbstractBox out) {
    connect(in, out);
  }

  public void connect(AbstractBox in, AbstractBox out) {
    disconnect();
    this.in = in;
    this.out = out;
    if (in != null) in.addOutput(this);
    if (out != null) out.addInput(this);
  }

  public void disconnect() {
    if (in != null) in.remInput(this);
    if (out != null) out.remOutput(this);
    in = null;
    out = null;
  }

  public void setSignal(Signal s) {
/*
System.out.print("SET " + String.valueOf(this.hashCode()) + " : ");
if (this.s == null) System.out.print("null <- ");
  else System.out.print(this.s.toString() + " <- ");
if (s == null) System.out.print("null ");
  else System.out.print(s.toString() + " ");
*/
    if (!changed) {
      if (this.s != null) changed = !this.s.equals(s);
      else changed = s != null;
    }
    if (s != null) this.s = s.copy();
    else this.s = null;

//System.out.println(changed);
  }

  public Signal getSignal() {
    return s;
  }

  public Object getSignalValue() {
    return s.getValue();
  }

  public boolean isChanged() {
    return changed;
  }

  public void setChanged(boolean state) {
    changed = state;
  }

  public Simulation[] simulate() {
    if ((changed)&&(out != null)) {
      Simulation[] sim = new Simulation[1];
      sim[0] = out;
      changed = false;
      return sim;
    } else {
      changed = false;
      return new Simulation[0];
    }
  }

  public long getStep() {
    if (s==null) return Signal.MIN_STEP;
    else return s.getStep();
  }

  public String toString() {
    String out;
    if (s == null) out = "{null";
      else out = "{" + s.toString();
    out += "," + String.valueOf(changed) + "}";
    return out;
  }
}