package drm.signal;

/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public interface BoxConnector {
  public void setInputs(Connector[] con);
  public void setInput(int nr, Connector con) throws ArrayIndexOutOfBoundsException;
  public Connector getInput(int nr) throws ArrayIndexOutOfBoundsException;
  public Connector[] getInputs();
  public int addInput(Connector con);
  public Connector remInput(int nr) throws ArrayIndexOutOfBoundsException;
  public boolean remInput(Connector con);

  public void setOutputs(Connector[] con);
  public void setOutput(int nr, Connector con) throws ArrayIndexOutOfBoundsException;
  public Connector getOutput(int nr) throws ArrayIndexOutOfBoundsException;
  public Connector[] getOutputs();
  public int addOutput(Connector con);
  public Connector remOutput(int nr) throws ArrayIndexOutOfBoundsException;
  public boolean remOutput(Connector con);

}