package drm.signal;

import java.util.*;

/**
 * <p>Title: Neuro Genetika</p>
 * <p>Description: Magistrinis darbas, genetinių algoritmų taikymo klasifikavimo uždaviniams spręsti tyrimas</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public abstract class AbstractBox implements BoxConnector, BoxSignal, Simulation {
  public Vector in = new Vector();
  public Vector out = new Vector();
  protected long step = Signal.MIN_STEP;

  public void setInputs(Connector[] con) {
    in.clear();
    for (int i=0; i<con.length; i++) in.add(con[i]);
  }

  public void setOutputs(Connector[] con) {
    out.clear();
    for (int i=0; i<con.length; i++) out.add(con[i]);
  }

  public void setInSignal(int nr, Signal s) throws ArrayIndexOutOfBoundsException {
    Connector bc = (Connector)in.get(nr);
    bc.setSignal(s);
  }

  public void setInput(int nr, Connector con) throws ArrayIndexOutOfBoundsException {
    in.set(nr, con);
  }

  public Connector getInput(int nr) throws ArrayIndexOutOfBoundsException {
    return (Connector)in.get(nr);
  }

  public Connector[] getInputs() {
    return (Connector[])in.toArray();
  }

  public Connector[] getOutputs() {
    return (Connector[])out.toArray();
  }

  public int addInput(Connector con) {
    in.add(con);
    return in.size() - 1;
  }

  public void setOutput(int nr, Connector con) throws ArrayIndexOutOfBoundsException {
    out.set(nr, con);
  }

  public Connector getOutput(int nr) throws ArrayIndexOutOfBoundsException {
    return (Connector)out.get(nr);
  }

  public int addOutput(Connector con) {
    out.add(con);
    return out.size() - 1;
  }

  public Connector remInput(int nr) throws ArrayIndexOutOfBoundsException {
    return (Connector)in.remove(nr);
  }

  public boolean remInput(Connector con) {
    return in.remove(con);
  }

  public Connector remOutput(int nr) throws ArrayIndexOutOfBoundsException {
    return (Connector)out.remove(nr);
  }

  public boolean remOutput(Connector con) {
    return out.remove(con);
  }



  public void setOutSignal(Signal s) {
    Iterator it = out.iterator();
    while (it.hasNext()) ((Connector)it.next()).setSignal(s);
  }

  public Signal getInSignal(int nr) throws ArrayIndexOutOfBoundsException {
    return ((Connector)in.get(nr)).getSignal();
  }

  public Object getInValue(int nr) throws ArrayIndexOutOfBoundsException {
    return ((Connector)in.get(nr)).getSignal().getValue();
  }

  public Signal[] getInSignals() {
    return (Signal[])in.toArray();
  }

  protected abstract void update();

  protected void setCurrentStep() {
    Iterator it = in.iterator();
    while (it.hasNext()) {
      Signal ts = ((Connector)it.next()).getSignal();
      long t = Signal.MIN_STEP;
      if (ts != null) ts.getStep();
      if (t > step) step = t;
    }
  }

  public Simulation[] simulate() {
    setCurrentStep();
    update();
    Iterator it = out.iterator();
    Vector t = new Vector();
    while (it.hasNext()) {
      Connector con = (Connector)it.next();
      if (con.isChanged()) t.add(con);
    }
    Simulation ts[] = new Simulation[t.size()];
    for (int i=0; i<ts.length; i++) ts[i] = (Simulation)t.get(i);
    return ts;
  }

  public long getStep() {
    return step;
  }

  public void setStep(long step) {
    this.step = step;
  }

  public void clearSignals() {
    Iterator it = out.iterator();
    while (it.hasNext()) ((Connector)it.next()).setSignal(null);
  }

}