package drm.genetics.simple;

import drm.genetics.*;

import java.util.Vector;
import java.util.Iterator;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: Genetinio Algoritmo Modeliuotojas</p>
 *
 * SimpleRunner specifika:
 *   Vieno žingsnio metu jis sukuria naują individų kartą su tokiu pačiu
 * individų skaičiu.
 *   1. Pradžioje į ją įtraukia nurodytą procentą geriausių individų jų
 * nemodifikuojant, taip pat juos paliekant senoje kartoje. Geriausiųjų
 * procentas pateikiamas kaip tikimybė nuo 0 iki 1 ir perskaičiavus apvalinamas
 * į viršų.
 *   2. Trūkstami individai gaunami iš senosios kartos individų, juos kryžminant
 * arba mutuojant.
 *
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class SimpleRunner extends AbstractRunner {
  public SimpleRunner() {
  }

  /**
   * mutacijos tikimybė
   */
  protected double mutationProbability = 0.1;
  /**
   * kryžminimo tikimybė
   */
  protected double crossoverProbability = 0.5;

  public void setMutationProbability(double mutationProbability) {
    this.mutationProbability = mutationProbability;
  }

  public void setCrossoverProbability(double crossoverProbability) {
    this.crossoverProbability = crossoverProbability;
  }

  public double getCrossoverProbability() {
    return crossoverProbability;
  }

  public double getMutationProbability() {
    return mutationProbability;
  }

  /**
   * Individų procentas, kurie patenką į naują kartą be pasikeitimų.
   */
  protected double bestPassPercentage = 0.1;

  public void setBestPassPercentage(double bestPassPercentage) {
    this.bestPassPercentage = bestPassPercentage;
  }

  public double getBestPassPercentage() {
    return bestPassPercentage;
  }

  public boolean DEBUG_BREEDER = false;

  public void step() {
    try {
if (DEBUG_BREEDER) System.out.print("breed: ");
      int size = individuals.size();
      Vector newRase = new Vector(size);
      // copying best genomes
      int howMuchBest = (int)Math.ceil(bestPassPercentage * (double)size);
      Iterator it = individuals.iterator();
      while ((it.hasNext())&&(newRase.size() < howMuchBest)) {
        Individual ind = (Individual)it.next();
        newRase.add(ind.copy());
if (DEBUG_BREEDER) System.out.print("E");
      }
      // creating the rest
      while (newRase.size() < size) {
        if (individuals.size() > 1) {
          Individual ind1 = getRandomIndividual();
          Individual ind2 = getRandomIndividual();

if (DEBUG_BREEDER) System.out.print("[");
          if (random.nextDouble() < crossoverProbability) { // atliekamas kryžminimas
            task.getCrossover().crossSame(ind1, ind2);
if (DEBUG_BREEDER) System.out.print("C");
          }

          if (random.nextDouble() < mutationProbability) { // atliekama mutacija
            task.getMutation().mutateSame(ind1);
if (DEBUG_BREEDER) System.out.print("M");
          }
          if (random.nextDouble() < mutationProbability) { // atliekama mutacija
            task.getMutation().mutateSame(ind2);
if (DEBUG_BREEDER) System.out.print("M");
          }

          newRase.add(ind1);
          if (newRase.size() < size) newRase.add(ind2);
if (DEBUG_BREEDER) System.out.print("]");
        }
      }
      // ending task
if (DEBUG_BREEDER) System.out.println();
      individuals.clear();
      individuals.addAll(newRase);
      stepCount++;
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
  }

}