package drm.genetics.simple;

import drm.genetics.*;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class SimpleMutation extends AbstractMutation {
  public SimpleMutation() {
  }

  public SimpleMutation(double percentage) {
    super(percentage);
  }

  public boolean DEBUG_INVERSE = false;

  public void mutateSame(Individual individ) {
    Gene[] genom = individ.accessGenome();
    int count = (int)Math.ceil(percentage * (double)genom.length);
    int[] num = randomNumbers(genom.length, count);
if (DEBUG_INVERSE) {
      System.out.print("Mutation, inverting: ");
      int[] debug = new int[genom.length];
      for (int i = 0; i < num.length; i++)
        debug[num[i]] = 1;
      for (int i = 0; i < debug.length; i++)
        System.out.print(debug[i]);
      System.out.println();
}
    for (int i=0; i<num.length; i++) ((Inversible)genom[num[i]]).inverse();
    individ.updateWeight();
  }

}