package drm.genetics.simple;

import drm.genetics.*;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class SimpleCrossover extends AbstractCrossover {
  public SimpleCrossover() {
  }

  public SimpleCrossover(int type) {
    super(type);
  }

  public boolean DEBUG_CROSS = false;

  public void crossSame(Individual individ1, Individual individ2) {
    int size = Math.min(individ1.accessGenome().length,
        individ2.accessGenome().length);
    Gene[] newGenom = individ1.getGenome();
    Gene[] gen1 = individ1.accessGenome();
    Gene[] gen2 = individ2.accessGenome();
int[] debug = new int[size];
    switch (type) {
      case TYPE_SINGLE_POINT : // kryžminimas per vieną tašką
        int p = random.nextInt(size);
        System.arraycopy(gen2, p, newGenom, p, size - p);
        System.arraycopy(gen1, p, gen2, p, size - p);
if (DEBUG_CROSS) for (int i=p; i<size; i++) debug[i] = 1;
        break;
      case TYPE_TWO_POINTS : // kryžminimas per du taškus
        int p1 = random.nextInt(size);
        int p2 = random.nextInt(size);
        int pt = Math.min(p1, p2);
        p2 = Math.max(p1, p2);
        p1 = pt;
//System.out.println("size:" + size + "; p1:" + p1 + "; p2:" + p2);
        System.arraycopy(gen2, p1, newGenom, p1, p2 - p1 + 1);
        System.arraycopy(gen1, p1, gen2, p1, p2 - p1 + 1);
if (DEBUG_CROSS) for (int i=p1; i<p2; i++) debug[i] = 1;
        break;
      case TYPE_RANDOM : // kryžminimas atsitiktinai
        for (int i=0; i<size; i++) if (random.nextBoolean()) {
            newGenom[i] = gen2[i];
            gen2[i] = gen1[i];
if (DEBUG_CROSS) debug[i] = 1;
          }
        break;
    }
if (DEBUG_CROSS) {
      System.out.print("Crossover, crossing: ");
      for (int i = 0; i < debug.length; i++) System.out.print(debug[i]);
      System.out.println();
}
    individ1.accessGenome(newGenom);
    individ2.updateWeight();
  }

}