package drm.genetics.simple;

import drm.genetics.Gene;
import drm.genetics.Inversible;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class IntegerGene implements Gene, Inversible {
  protected int value = 0;
  protected int min = -1, max = 1;

  public IntegerGene() {
  }

  public IntegerGene(int value, int min, int max) {
    setRange(min, max);
    set(value);
  }

  public void set(int value) {
    this.value = Math.min(max, Math.max(min, value));
  }

  public int get() {
    return value;
  }

  public void setMin(int min) {
    this.min = min;
    value = Math.max(value, min);
    max = Math.max(max, min);
  }

  public int getMin() {
    return min;
  }

  public void setMax(int max) {
    this.max = max;
    value = Math.min(value, max);
    min = Math.min(max, min);
  }

  public void setRange(int min, int max) {
    setMin(min);
    setMax(max);
  }

  public int getMax() {
    return max;
  }

  public void inverse() {
    int range = max - min;
    value = (int)(Math.random() * range + min);
  }

  public String toString() {
    return String.valueOf(value);
  }
}
