package drm.genetics.simple;

import drm.genetics.Gene;
import drm.genetics.Inversible;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class DoubleGene implements Gene, Inversible {
  protected double value = 0;
  protected double min = -1, max = 1;

  public DoubleGene() {
  }

  public DoubleGene(double value, double min, double max) {
    setRange(min, max);
    set(value);
  }

  public void set(double value) {
    this.value = Math.min(max, Math.max(min, value));
  }

  public double get() {
    return value;
  }

  public void setMin(double min) {
    this.min = min;
    value = Math.max(value, min);
    max = Math.max(max, min);
  }

  public double getMin() {
    return min;
  }

  public void setMax(double max) {
    this.max = max;
    value = Math.min(value, max);
    min = Math.min(max, min);
  }

  public void setRange(double min, double max) {
    setMin(min);
    setMax(max);
  }

  public double getMax() {
    return max;
  }

  public void inverse() {
    double range = max - min;
    value = Math.random() * range + min;
//System.out.println(min + " - " + max + " >> " + value);
  }

  public String toString() {
    return String.valueOf(value);
  }
}