package drm.genetics.advanced;

import drm.genetics.simple.*;
import drm.genetics.*;


/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class BestSelMutation extends SimpleMutation {
  /**
   * bandymų mutuojant atrasti geriausią individą kiekis
   */
  protected int tries = 2;

  public void setTries(int tries) {
    this.tries = tries;
  }
  public int getTries() {
    return tries;
  }

  public BestSelMutation() {
  }

  public BestSelMutation(double percentage) {
    super(percentage);
  }

  public BestSelMutation(double percentage, int tries) {
    super(percentage);
    setTries(tries);
  }

  /**
   * Atliekama individo mutacija
   * 1. atliekama paprasta genų mutacija (SimpleMutation)
   * 2. toliau nagrinėjamas tas individas, kuris yra geresnis senasis arba
   * naujasis.
   * Ciklas tęsiamas nurodytą kiekį kartų (tries)
   * @param individ individas
   * @see SimpleMutation
   * @see tries
   */
  public void mutateSame(Individual individ) {
    Individual ind1 = individ.copy();
    Individual ind2 = individ.copy();
    for (int i = 0; i < tries; i++) {
      super.mutateSame(ind1);
      if (ind2.compareTo(ind1) > 0) {
        ind1 = ind2.copy();
      } else if (ind1.compareTo(ind2) > 0) {
        ind2 = ind1.copy();
      }
    }
    individ.accessGenome(ind1.getGenome());
    individ.updateWeight();
  }
}