package drm.genetics.advanced;

import drm.genetics.simple.SimpleCrossover;
import drm.genetics.Individual;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public class BestSelCrossover extends SimpleCrossover {
  /**
   * bandymų kryžminant atrasti geriausią individą kiekis
   */
  protected int tries = 2;

  public void setTries(int tries) {
    this.tries = tries;
  }
  public int getTries() {
    return tries;
  }

  public BestSelCrossover() {
  }

  public BestSelCrossover(int type) {
    super(type);
  }

  public BestSelCrossover(int type, int tries) {
    super(type);
    setTries(tries);
  }

  /**
   * Atliekamas individų kryžminimas
   * 1. atliekamas paprastas apsikeitimas genais (SimpleCrossover)
   * 2. atrenkami du geriausi individai ir veiksmas vėl pradedamas nuo pradžių
   * Ciklas tęsiamas nurodytą kiekį kartų (tries)
   * @param individ1 individas
   * @param individ2 individas
   * @see SimpleCrossover
   * @see tries
   */
  public void crossSame(Individual individ1, Individual individ2) {
    Individual ind1 = individ1;
    Individual ind2 = individ2;
    Individual rez;
    if (ind1.compareTo(ind2) > 0) rez = ind1.copy();
      else rez = ind2.copy();
    for (int i = 0; i < tries; i++) {
      super.crossSame(ind1, ind2);
      if (ind1.compareTo(ind2) > 0) {
        if (rez.compareTo(ind2) > 0) ind2 = rez;
        if (ind1.compareTo(rez) > 0) rez = ind1.copy();
      } else {
        if (rez.compareTo(ind1) > 0) ind1 = rez;
        if (ind2.compareTo(rez) > 0) rez = ind2.copy();
      }
    }
    individ1.accessGenome(ind1.getGenome());
    individ1.updateWeight();
    individ2.accessGenome(ind1.getGenome());
    individ2.updateWeight();
  }
}