package drm.genetics;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public interface Task {
  /**
   * Sukuria individus pradinėje stadijoje.
   * @return sukurti pradiniai individai
   */
  public Individual[] createIndividuals();

  /**
   * Gražinama mutacija. Metodas turi būti greitai veikiantis, t.y. šiame
   * metode nereikėtų kurti naujų objektų.
   * @return mutacija
   * @see Mutation
   */
  public Mutation getMutation();

  /**
   * Gražinamas kryžminimas. Metodas turi būti greitai veikiantis, t.y. šiame
   * metode nereikėtų kurti naujų objektų.
   * @return mutacija
   * @see Crossover
   */
  public Crossover getCrossover();

  /**
   * Nustatoma individo kokybė, kurią pasiekus bus nutraukiami skaičiavimai.
   * @return individo minimali kokybė
   */
  public double getRequeredWeight();


}