package drm.genetics;

import java.util.Collection;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public interface Runner
{
  /**
   * inicijuojamas Vykdymo objektas.
   * @param task vartotojo specifinė užduotis
   */
  public void init(Task task);

  /**
   * Vykdo metodą step kol nesustabdomas. Metodas grįžta iš karto -
   * skaičiavimams paleidžiama atskira gija.
   */
  public void start();

  /**
   * Sustabdo start metode paleistą giją.
   */
  public void stop();

  /**
   * Performs all operations with a single generation. Must be inited. Makes new
   * generation from the old one.
   */
  public void step();

  /**
   * Performs n steps - n generations. Calls step() n times.
   * @param     n        defines how many steps to perform
   */
  public void step(int n);

  /**
   * Gražina tiesioginį priėjimą prie visų individų.
   * @return visi individai
   */
  public Collection accessIndivids();

  /**
   * Gauna nurodytą individą ir individas pašalinamas iš aktyvių individų
   * sąrašo.
   * @param nr individo numeris
   * @return individas
   * @throws IndexOutOfBoundsException
   */
  public Individual getIndividual(int nr) throws IndexOutOfBoundsException;

  /**
   * Individas pridedamas prie aktyvių individų sąrašo.
   * @param individual individas
   */
  public void addIndividual(Individual individual);

  /**
   * Iš individų sąrašo išimamas atsitiktinis individas ir gražinamas. Individo
   * sąraše nebelieka.
   * @return atsitiktinis sąrašo individas
   */
  public Individual getRandomIndividual();

  /**
   * Returns number of steps performed.
   * @return steps count
   */
  public int getAge();

}
