package drm.genetics;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public interface Mutation {
  /**
   * Nustatoma kokiai individo genų daliai taikyti kryžminimą.
   * @param percentage genomo mutacijos dalis nuo 0 iki 1, jei mažiau nei 0,
   * bus nustatyta į 0, jei daugiau nei 1 - į 1.
   */
  public void setPercentage(double percentage);

  /**
   * Nustatoma kokiai individo genų daliai taikyti kryžminimą.
   * @return individo kryžminimo dalis.
   */
  public double getPercentage();

  /**
   * Vykdoma individo genų mutacija. individ nemodifikuojamas.
   * @param individ individas
   * @return naujas individas
   */
  public Individual mutate(Individual individ);

  /**
   * Vykdoma individo genų mutacija.
   * @param individ mutuojamas individas
   */
  public void mutateSame(Individual individ);
}