package drm.genetics;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public interface Individual extends Comparable {
  /**
   * Gaunamas tiesioginis priėjimas prie genų rinkinio
   * @return genomas
   */
  public Gene[] accessGenome();

  /**
   * Individo genomas nustatomas į nurodytą genomą
   * @param genome genomas
   */
  public void accessGenome(Gene[] genome);

  /**
   * Gaunama genomo kopija
   * @return genomo kopija
   */
  public Gene[] getGenome();

  /**
   * Individo genomui priskiriama nurodyto genomo kopija
   * @param genome genomas
   */
  public void setGenome(Gene[] genome);

  /**
   * Gražina individo kokybę. Kuo skaičius didesnis, tuo
   * individas kokybiškesnis.
   * @return individo kokybė
   */
  public double getWeight();

  /**
   * Nustato kiek kokybiškas yra šis individas. Kuo skaičius didesnis, tuo
   * individas kokybiškesnis.
   * @return individo kokybė
   */
  public double updateWeight();

  public Individual copy();
}