package drm.genetics;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public interface Crossover {
  /**
   * Kryžminimo tipas - atsitiktinis.
   * Kryžminama atsitiktinai išrenkant genus.
   */
  public static final int TYPE_RANDOM = -1;

  /**
   * Kryžminimo tipas - per vieną tašką.
   * Kryžminama iš vieno individo paimant genomo pradžią, iš kito pabaigą.
   */
  public static final int TYPE_SINGLE_POINT = 1;

  /**
   * Kryžminimo tipas - per du taškus.
   * Kryžminama į vieno individo genomo vidurį įterpiami kito individo
   * viduriniai genai.
   */
  public static final int TYPE_TWO_POINTS = 2;

  public void setType(int type);
  public int getType();

  /**
   * Atliekamas individų kryžminimas. individ1 ir individ2 nemodifikuojami.
   * @param individ1 pirmas individas
   * @param individ2 antras individas
   * @return naujas individas.
   */
  public Individual cross(Individual individ1, Individual individ2);

  /**
   * Atliekamas individų kryžminimas. individ1 ir individ2 modifikuojami.
   * @param individ1 pirmas individas
   * @param individ2 antras individas
   */
  public void crossSame(Individual individ1, Individual individ2);
}