package drm.genetics;

import java.util.Collection;
import java.util.TreeSet;
import java.util.Iterator;
import java.util.Random;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public abstract class AbstractRunner implements Runner {
  /**
   * "Gyvų" individų sąrašas
   */
  protected TreeSet individuals = new TreeSet();

  /**
   * Gauna nurodytą individą ir individas pašalinamas iš aktyvių individų
   * sąrašo.
   * @param nr individo numeris
   * @return individas
   * @throws IndexOutOfBoundsException
   */
  public Individual getIndividual(int nr) throws IndexOutOfBoundsException {
    Iterator it = individuals.iterator();
    Object ob = null;
    int i = -1;
    while ((it.hasNext())&&(i < nr)) {
      ob = it.next();
      i++;
    }
    if (i == nr) {
      it.remove();
    } else {
      ob = null;
      throw new IndexOutOfBoundsException("index = " + String.valueOf(nr));
    }
    return (Individual)ob;
  }

  /**
   * Individas pridedamas prie aktyvių individų sąrašo.
   * @param individual individas
   */
  public void addIndividual(Individual individual) {
    individuals.add(individual);
  }

  protected Random random = new Random();

  /**
   * Gražina atsitiktinį skaičių nuo 0 iki 1.
   * Funkcija naudojama (getRandomIndividual) gaunant atsitiktinį individą,
   * t.y. kuo su didesne tikimybę iškris skaičius artimesni 0, tuo dažniau bus
   * pasirenkamas kokybiškesnis individas.
   *
   * Čia naudojama parabolinė funkcija.
   * @return atsitiktinis skaičius
   */
  protected double getRandomFunction() {
    return random.nextDouble() * random.nextDouble();
  }

  /**
   * Iš individų sąrašo išimamas atsitiktinis individas ir gražinamas. Individo
   * sąraše nebelieka.
   * @return atsitiktinis sąrašo individas
   */
  public Individual getRandomIndividual() {
    int nr = (int)(getRandomFunction() * (double)individuals.size());
    // dėl viso pikto funkcija apkarpoma, ypač reiktų atkreipti dėmesį į tai
    // kad getRandomFunction() gali gražinti 1.
    nr = Math.max(0, Math.min(individuals.size() - 1, nr));
    return getIndividual(nr);
  }

  /**
   * Įvykdytų žingsnių skaičius.
   */
  protected int stepCount = 0;

  /**
   * Vartotojo specifinė užduotis
   */
  protected Task task = null;

  public void init(Task task) {
    this.task = task;
    Individual[] ind = task.createIndividuals();
    individuals.clear();
    for (int i=0; i<ind.length; i++) addIndividual(ind[i]);
  }

  protected boolean interupted = false;

  public synchronized void start() {
    while ((!interupted)&&(((Individual)individuals.first()).getWeight() <
        task.getRequeredWeight())) step();
    interupted = false;
  }

  public synchronized void stop() {
    interupted = true;
  }

  public void step(int n) {
    for (int i=0;
        (i<n)&&(((Individual)individuals.first()).getWeight() <
        task.getRequeredWeight()); i++) step();
  }

  public Collection accessIndivids() {
    return individuals;
  }

  public int getAge() {
    return stepCount;
  }
}